/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.VirtualMachinePatchProperties;
import com.azure.resourcemanager.networkcloud.models.ImageRepositoryCredentials;
import java.io.IOException;
import java.util.Map;

public final class VirtualMachinePatchParameters
implements JsonSerializable<VirtualMachinePatchParameters> {
    private VirtualMachinePatchProperties innerProperties;
    private Map<String, String> tags;

    private VirtualMachinePatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public VirtualMachinePatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public ImageRepositoryCredentials vmImageRepositoryCredentials() {
        return this.innerProperties() == null ? null : this.innerProperties().vmImageRepositoryCredentials();
    }

    public VirtualMachinePatchParameters withVmImageRepositoryCredentials(ImageRepositoryCredentials vmImageRepositoryCredentials) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachinePatchProperties();
        }
        this.innerProperties().withVmImageRepositoryCredentials(vmImageRepositoryCredentials);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachinePatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachinePatchParameters)jsonReader.readObject(reader -> {
            VirtualMachinePatchParameters deserializedVirtualMachinePatchParameters = new VirtualMachinePatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachinePatchParameters.innerProperties = VirtualMachinePatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedVirtualMachinePatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachinePatchParameters;
        });
    }
}

