/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.OsDisk;
import java.io.IOException;
import java.util.List;

public final class StorageProfile
implements JsonSerializable<StorageProfile> {
    private OsDisk osDisk;
    private List<String> volumeAttachments;
    private static final ClientLogger LOGGER = new ClientLogger(StorageProfile.class);

    public OsDisk osDisk() {
        return this.osDisk;
    }

    public StorageProfile withOsDisk(OsDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    public List<String> volumeAttachments() {
        return this.volumeAttachments;
    }

    public StorageProfile withVolumeAttachments(List<String> volumeAttachments) {
        this.volumeAttachments = volumeAttachments;
        return this;
    }

    public void validate() {
        if (this.osDisk() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property osDisk in model StorageProfile"));
        }
        this.osDisk().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDisk", (JsonSerializable)this.osDisk);
        jsonWriter.writeArrayField("volumeAttachments", this.volumeAttachments, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static StorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (StorageProfile)jsonReader.readObject(reader -> {
            StorageProfile deserializedStorageProfile = new StorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("osDisk".equals(fieldName)) {
                    deserializedStorageProfile.osDisk = OsDisk.fromJson(reader);
                    continue;
                }
                if ("volumeAttachments".equals(fieldName)) {
                    List volumeAttachments;
                    deserializedStorageProfile.volumeAttachments = volumeAttachments = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageProfile;
        });
    }
}

