/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineConfigurationData;
import com.azure.resourcemanager.networkcloud.models.StorageApplianceConfigurationData;
import java.io.IOException;
import java.util.List;

public final class RackDefinition
implements JsonSerializable<RackDefinition> {
    private String availabilityZone;
    private List<BareMetalMachineConfigurationData> bareMetalMachineConfigurationData;
    private String networkRackId;
    private String rackLocation;
    private String rackSerialNumber;
    private String rackSkuId;
    private List<StorageApplianceConfigurationData> storageApplianceConfigurationData;
    private static final ClientLogger LOGGER = new ClientLogger(RackDefinition.class);

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public RackDefinition withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public List<BareMetalMachineConfigurationData> bareMetalMachineConfigurationData() {
        return this.bareMetalMachineConfigurationData;
    }

    public RackDefinition withBareMetalMachineConfigurationData(List<BareMetalMachineConfigurationData> bareMetalMachineConfigurationData) {
        this.bareMetalMachineConfigurationData = bareMetalMachineConfigurationData;
        return this;
    }

    public String networkRackId() {
        return this.networkRackId;
    }

    public RackDefinition withNetworkRackId(String networkRackId) {
        this.networkRackId = networkRackId;
        return this;
    }

    public String rackLocation() {
        return this.rackLocation;
    }

    public RackDefinition withRackLocation(String rackLocation) {
        this.rackLocation = rackLocation;
        return this;
    }

    public String rackSerialNumber() {
        return this.rackSerialNumber;
    }

    public RackDefinition withRackSerialNumber(String rackSerialNumber) {
        this.rackSerialNumber = rackSerialNumber;
        return this;
    }

    public String rackSkuId() {
        return this.rackSkuId;
    }

    public RackDefinition withRackSkuId(String rackSkuId) {
        this.rackSkuId = rackSkuId;
        return this;
    }

    public List<StorageApplianceConfigurationData> storageApplianceConfigurationData() {
        return this.storageApplianceConfigurationData;
    }

    public RackDefinition withStorageApplianceConfigurationData(List<StorageApplianceConfigurationData> storageApplianceConfigurationData) {
        this.storageApplianceConfigurationData = storageApplianceConfigurationData;
        return this;
    }

    public void validate() {
        if (this.bareMetalMachineConfigurationData() != null) {
            this.bareMetalMachineConfigurationData().forEach(e -> e.validate());
        }
        if (this.networkRackId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property networkRackId in model RackDefinition"));
        }
        if (this.rackSerialNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackSerialNumber in model RackDefinition"));
        }
        if (this.rackSkuId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property rackSkuId in model RackDefinition"));
        }
        if (this.storageApplianceConfigurationData() != null) {
            this.storageApplianceConfigurationData().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkRackId", this.networkRackId);
        jsonWriter.writeStringField("rackSerialNumber", this.rackSerialNumber);
        jsonWriter.writeStringField("rackSkuId", this.rackSkuId);
        jsonWriter.writeStringField("availabilityZone", this.availabilityZone);
        jsonWriter.writeArrayField("bareMetalMachineConfigurationData", this.bareMetalMachineConfigurationData, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("rackLocation", this.rackLocation);
        jsonWriter.writeArrayField("storageApplianceConfigurationData", this.storageApplianceConfigurationData, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RackDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (RackDefinition)jsonReader.readObject(reader -> {
            RackDefinition deserializedRackDefinition = new RackDefinition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("networkRackId".equals(fieldName)) {
                    deserializedRackDefinition.networkRackId = reader.getString();
                    continue;
                }
                if ("rackSerialNumber".equals(fieldName)) {
                    deserializedRackDefinition.rackSerialNumber = reader.getString();
                    continue;
                }
                if ("rackSkuId".equals(fieldName)) {
                    deserializedRackDefinition.rackSkuId = reader.getString();
                    continue;
                }
                if ("availabilityZone".equals(fieldName)) {
                    deserializedRackDefinition.availabilityZone = reader.getString();
                    continue;
                }
                if ("bareMetalMachineConfigurationData".equals(fieldName)) {
                    List bareMetalMachineConfigurationData;
                    deserializedRackDefinition.bareMetalMachineConfigurationData = bareMetalMachineConfigurationData = reader.readArray(reader1 -> BareMetalMachineConfigurationData.fromJson(reader1));
                    continue;
                }
                if ("rackLocation".equals(fieldName)) {
                    deserializedRackDefinition.rackLocation = reader.getString();
                    continue;
                }
                if ("storageApplianceConfigurationData".equals(fieldName)) {
                    List storageApplianceConfigurationData;
                    deserializedRackDefinition.storageApplianceConfigurationData = storageApplianceConfigurationData = reader.readArray(reader1 -> StorageApplianceConfigurationData.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackDefinition;
        });
    }
}

