/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import com.azure.resourcemanager.networkcloud.models.AgentOptions;
import com.azure.resourcemanager.networkcloud.models.AgentPoolMode;
import com.azure.resourcemanager.networkcloud.models.AgentPoolUpgradeSettings;
import com.azure.resourcemanager.networkcloud.models.AttachedNetworkConfiguration;
import com.azure.resourcemanager.networkcloud.models.KubernetesLabel;
import java.io.IOException;
import java.util.List;

public final class InitialAgentPoolConfiguration
implements JsonSerializable<InitialAgentPoolConfiguration> {
    private AdministratorConfiguration administratorConfiguration;
    private AgentOptions agentOptions;
    private AttachedNetworkConfiguration attachedNetworkConfiguration;
    private List<String> availabilityZones;
    private long count;
    private List<KubernetesLabel> labels;
    private AgentPoolMode mode;
    private String name;
    private List<KubernetesLabel> taints;
    private AgentPoolUpgradeSettings upgradeSettings;
    private String vmSkuName;
    private static final ClientLogger LOGGER = new ClientLogger(InitialAgentPoolConfiguration.class);

    public AdministratorConfiguration administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public InitialAgentPoolConfiguration withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public AgentOptions agentOptions() {
        return this.agentOptions;
    }

    public InitialAgentPoolConfiguration withAgentOptions(AgentOptions agentOptions) {
        this.agentOptions = agentOptions;
        return this;
    }

    public AttachedNetworkConfiguration attachedNetworkConfiguration() {
        return this.attachedNetworkConfiguration;
    }

    public InitialAgentPoolConfiguration withAttachedNetworkConfiguration(AttachedNetworkConfiguration attachedNetworkConfiguration) {
        this.attachedNetworkConfiguration = attachedNetworkConfiguration;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public InitialAgentPoolConfiguration withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public long count() {
        return this.count;
    }

    public InitialAgentPoolConfiguration withCount(long count) {
        this.count = count;
        return this;
    }

    public List<KubernetesLabel> labels() {
        return this.labels;
    }

    public InitialAgentPoolConfiguration withLabels(List<KubernetesLabel> labels) {
        this.labels = labels;
        return this;
    }

    public AgentPoolMode mode() {
        return this.mode;
    }

    public InitialAgentPoolConfiguration withMode(AgentPoolMode mode) {
        this.mode = mode;
        return this;
    }

    public String name() {
        return this.name;
    }

    public InitialAgentPoolConfiguration withName(String name) {
        this.name = name;
        return this;
    }

    public List<KubernetesLabel> taints() {
        return this.taints;
    }

    public InitialAgentPoolConfiguration withTaints(List<KubernetesLabel> taints) {
        this.taints = taints;
        return this;
    }

    public AgentPoolUpgradeSettings upgradeSettings() {
        return this.upgradeSettings;
    }

    public InitialAgentPoolConfiguration withUpgradeSettings(AgentPoolUpgradeSettings upgradeSettings) {
        this.upgradeSettings = upgradeSettings;
        return this;
    }

    public String vmSkuName() {
        return this.vmSkuName;
    }

    public InitialAgentPoolConfiguration withVmSkuName(String vmSkuName) {
        this.vmSkuName = vmSkuName;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.agentOptions() != null) {
            this.agentOptions().validate();
        }
        if (this.attachedNetworkConfiguration() != null) {
            this.attachedNetworkConfiguration().validate();
        }
        if (this.labels() != null) {
            this.labels().forEach(e -> e.validate());
        }
        if (this.mode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property mode in model InitialAgentPoolConfiguration"));
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model InitialAgentPoolConfiguration"));
        }
        if (this.taints() != null) {
            this.taints().forEach(e -> e.validate());
        }
        if (this.upgradeSettings() != null) {
            this.upgradeSettings().validate();
        }
        if (this.vmSkuName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmSkuName in model InitialAgentPoolConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("count", this.count);
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("vmSkuName", this.vmSkuName);
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeJsonField("agentOptions", (JsonSerializable)this.agentOptions);
        jsonWriter.writeJsonField("attachedNetworkConfiguration", (JsonSerializable)this.attachedNetworkConfiguration);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("labels", this.labels, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("taints", this.taints, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("upgradeSettings", (JsonSerializable)this.upgradeSettings);
        return jsonWriter.writeEndObject();
    }

    public static InitialAgentPoolConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (InitialAgentPoolConfiguration)jsonReader.readObject(reader -> {
            InitialAgentPoolConfiguration deserializedInitialAgentPoolConfiguration = new InitialAgentPoolConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.count = reader.getLong();
                    continue;
                }
                if ("mode".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.mode = AgentPoolMode.fromString(reader.getString());
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.name = reader.getString();
                    continue;
                }
                if ("vmSkuName".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.vmSkuName = reader.getString();
                    continue;
                }
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.administratorConfiguration = AdministratorConfiguration.fromJson(reader);
                    continue;
                }
                if ("agentOptions".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.agentOptions = AgentOptions.fromJson(reader);
                    continue;
                }
                if ("attachedNetworkConfiguration".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.attachedNetworkConfiguration = AttachedNetworkConfiguration.fromJson(reader);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedInitialAgentPoolConfiguration.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("labels".equals(fieldName)) {
                    List labels;
                    deserializedInitialAgentPoolConfiguration.labels = labels = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("taints".equals(fieldName)) {
                    List taints;
                    deserializedInitialAgentPoolConfiguration.taints = taints = reader.readArray(reader1 -> KubernetesLabel.fromJson(reader1));
                    continue;
                }
                if ("upgradeSettings".equals(fieldName)) {
                    deserializedInitialAgentPoolConfiguration.upgradeSettings = AgentPoolUpgradeSettings.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedInitialAgentPoolConfiguration;
        });
    }
}

