/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.AdministratorConfiguration;
import java.io.IOException;
import java.util.List;

public final class ControlPlaneNodeConfiguration
implements JsonSerializable<ControlPlaneNodeConfiguration> {
    private AdministratorConfiguration administratorConfiguration;
    private List<String> availabilityZones;
    private long count;
    private String vmSkuName;
    private static final ClientLogger LOGGER = new ClientLogger(ControlPlaneNodeConfiguration.class);

    public AdministratorConfiguration administratorConfiguration() {
        return this.administratorConfiguration;
    }

    public ControlPlaneNodeConfiguration withAdministratorConfiguration(AdministratorConfiguration administratorConfiguration) {
        this.administratorConfiguration = administratorConfiguration;
        return this;
    }

    public List<String> availabilityZones() {
        return this.availabilityZones;
    }

    public ControlPlaneNodeConfiguration withAvailabilityZones(List<String> availabilityZones) {
        this.availabilityZones = availabilityZones;
        return this;
    }

    public long count() {
        return this.count;
    }

    public ControlPlaneNodeConfiguration withCount(long count) {
        this.count = count;
        return this;
    }

    public String vmSkuName() {
        return this.vmSkuName;
    }

    public ControlPlaneNodeConfiguration withVmSkuName(String vmSkuName) {
        this.vmSkuName = vmSkuName;
        return this;
    }

    public void validate() {
        if (this.administratorConfiguration() != null) {
            this.administratorConfiguration().validate();
        }
        if (this.vmSkuName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property vmSkuName in model ControlPlaneNodeConfiguration"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeLongField("count", this.count);
        jsonWriter.writeStringField("vmSkuName", this.vmSkuName);
        jsonWriter.writeJsonField("administratorConfiguration", (JsonSerializable)this.administratorConfiguration);
        jsonWriter.writeArrayField("availabilityZones", this.availabilityZones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ControlPlaneNodeConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (ControlPlaneNodeConfiguration)jsonReader.readObject(reader -> {
            ControlPlaneNodeConfiguration deserializedControlPlaneNodeConfiguration = new ControlPlaneNodeConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("count".equals(fieldName)) {
                    deserializedControlPlaneNodeConfiguration.count = reader.getLong();
                    continue;
                }
                if ("vmSkuName".equals(fieldName)) {
                    deserializedControlPlaneNodeConfiguration.vmSkuName = reader.getString();
                    continue;
                }
                if ("administratorConfiguration".equals(fieldName)) {
                    deserializedControlPlaneNodeConfiguration.administratorConfiguration = AdministratorConfiguration.fromJson(reader);
                    continue;
                }
                if ("availabilityZones".equals(fieldName)) {
                    List availabilityZones;
                    deserializedControlPlaneNodeConfiguration.availabilityZones = availabilityZones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedControlPlaneNodeConfiguration;
        });
    }
}

