/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.fluent.models.ConsoleInner;
import com.azure.resourcemanager.networkcloud.models.ConsoleDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.ConsoleEnabled;
import com.azure.resourcemanager.networkcloud.models.ConsoleProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.SshPublicKey;
import java.time.OffsetDateTime;
import java.util.Map;

public interface Console {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public ExtendedLocation extendedLocation();

    public SystemData systemData();

    public ConsoleDetailedStatus detailedStatus();

    public String detailedStatusMessage();

    public ConsoleEnabled enabled();

    public OffsetDateTime expiration();

    public String privateLinkServiceId();

    public ConsoleProvisioningState provisioningState();

    public SshPublicKey sshPublicKey();

    public String virtualMachineAccessId();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public ConsoleInner innerModel();

    public Update update();

    public Console refresh();

    public Console refresh(Context var1);

    public static interface UpdateStages {

        public static interface WithIfNoneMatch {
            public Update withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public Update withIfMatch(String var1);
        }

        public static interface WithSshPublicKey {
            public Update withSshPublicKey(SshPublicKey var1);
        }

        public static interface WithExpiration {
            public Update withExpiration(OffsetDateTime var1);
        }

        public static interface WithEnabled {
            public Update withEnabled(ConsoleEnabled var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEnabled,
    UpdateStages.WithExpiration,
    UpdateStages.WithSshPublicKey,
    UpdateStages.WithIfMatch,
    UpdateStages.WithIfNoneMatch {
        public Console apply();

        public Console apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithIfNoneMatch {
            public WithCreate withIfNoneMatch(String var1);
        }

        public static interface WithIfMatch {
            public WithCreate withIfMatch(String var1);
        }

        public static interface WithExpiration {
            public WithCreate withExpiration(OffsetDateTime var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithExpiration,
        WithIfMatch,
        WithIfNoneMatch {
            public Console create();

            public Console create(Context var1);
        }

        public static interface WithSshPublicKey {
            public WithCreate withSshPublicKey(SshPublicKey var1);
        }

        public static interface WithEnabled {
            public WithSshPublicKey withEnabled(ConsoleEnabled var1);
        }

        public static interface WithExtendedLocation {
            public WithEnabled withExtendedLocation(ExtendedLocation var1);
        }

        public static interface WithParentResource {
            public WithExtendedLocation withExistingVirtualMachine(String var1, String var2);
        }

        public static interface WithLocation {
            public WithParentResource withRegion(Region var1);

            public WithParentResource withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithParentResource,
    DefinitionStages.WithExtendedLocation,
    DefinitionStages.WithEnabled,
    DefinitionStages.WithSshPublicKey,
    DefinitionStages.WithCreate {
    }
}

