/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.models.IdentitySelector;
import java.io.IOException;

public final class CommandOutputSettings
implements JsonSerializable<CommandOutputSettings> {
    private IdentitySelector associatedIdentity;
    private String containerUrl;

    public IdentitySelector associatedIdentity() {
        return this.associatedIdentity;
    }

    public CommandOutputSettings withAssociatedIdentity(IdentitySelector associatedIdentity) {
        this.associatedIdentity = associatedIdentity;
        return this;
    }

    public String containerUrl() {
        return this.containerUrl;
    }

    public CommandOutputSettings withContainerUrl(String containerUrl) {
        this.containerUrl = containerUrl;
        return this;
    }

    public void validate() {
        if (this.associatedIdentity() != null) {
            this.associatedIdentity().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("associatedIdentity", (JsonSerializable)this.associatedIdentity);
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        return jsonWriter.writeEndObject();
    }

    public static CommandOutputSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CommandOutputSettings)jsonReader.readObject(reader -> {
            CommandOutputSettings deserializedCommandOutputSettings = new CommandOutputSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("associatedIdentity".equals(fieldName)) {
                    deserializedCommandOutputSettings.associatedIdentity = IdentitySelector.fromJson(reader);
                    continue;
                }
                if ("containerUrl".equals(fieldName)) {
                    deserializedCommandOutputSettings.containerUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCommandOutputSettings;
        });
    }
}

