/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkPatchProperties;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CloudServicesNetworkPatchParameters
implements JsonSerializable<CloudServicesNetworkPatchParameters> {
    private CloudServicesNetworkPatchProperties innerProperties;
    private Map<String, String> tags;

    private CloudServicesNetworkPatchProperties innerProperties() {
        return this.innerProperties;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public CloudServicesNetworkPatchParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public List<EgressEndpoint> additionalEgressEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalEgressEndpoints();
    }

    public CloudServicesNetworkPatchParameters withAdditionalEgressEndpoints(List<EgressEndpoint> additionalEgressEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CloudServicesNetworkPatchProperties();
        }
        this.innerProperties().withAdditionalEgressEndpoints(additionalEgressEndpoints);
        return this;
    }

    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints() {
        return this.innerProperties() == null ? null : this.innerProperties().enableDefaultEgressEndpoints();
    }

    public CloudServicesNetworkPatchParameters withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints) {
        if (this.innerProperties() == null) {
            this.innerProperties = new CloudServicesNetworkPatchProperties();
        }
        this.innerProperties().withEnableDefaultEgressEndpoints(enableDefaultEgressEndpoints);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServicesNetworkPatchParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServicesNetworkPatchParameters)jsonReader.readObject(reader -> {
            CloudServicesNetworkPatchParameters deserializedCloudServicesNetworkPatchParameters = new CloudServicesNetworkPatchParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("properties".equals(fieldName)) {
                    deserializedCloudServicesNetworkPatchParameters.innerProperties = CloudServicesNetworkPatchProperties.fromJson(reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedCloudServicesNetworkPatchParameters.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServicesNetworkPatchParameters;
        });
    }
}

