/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.MetricsConfigurationsClient;
import com.azure.resourcemanager.networkcloud.fluent.models.ClusterMetricsConfigurationInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.ClusterMetricsConfigurationImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.ClusterMetricsConfiguration;
import com.azure.resourcemanager.networkcloud.models.MetricsConfigurations;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class MetricsConfigurationsImpl
implements MetricsConfigurations {
    private static final ClientLogger LOGGER = new ClientLogger(MetricsConfigurationsImpl.class);
    private final MetricsConfigurationsClient innerClient;
    private final NetworkCloudManager serviceManager;

    public MetricsConfigurationsImpl(MetricsConfigurationsClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<ClusterMetricsConfiguration> listByCluster(String resourceGroupName, String clusterName) {
        PagedIterable<ClusterMetricsConfigurationInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterMetricsConfigurationImpl((ClusterMetricsConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ClusterMetricsConfiguration> listByCluster(String resourceGroupName, String clusterName, Context context) {
        PagedIterable<ClusterMetricsConfigurationInner> inner = this.serviceClient().listByCluster(resourceGroupName, clusterName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ClusterMetricsConfigurationImpl((ClusterMetricsConfigurationInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<ClusterMetricsConfiguration> getWithResponse(String resourceGroupName, String clusterName, String metricsConfigurationName, Context context) {
        Response<ClusterMetricsConfigurationInner> inner = this.serviceClient().getWithResponse(resourceGroupName, clusterName, metricsConfigurationName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ClusterMetricsConfigurationImpl((ClusterMetricsConfigurationInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ClusterMetricsConfiguration get(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        ClusterMetricsConfigurationInner inner = this.serviceClient().get(resourceGroupName, clusterName, metricsConfigurationName);
        if (inner != null) {
            return new ClusterMetricsConfigurationImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String metricsConfigurationName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, metricsConfigurationName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String clusterName, String metricsConfigurationName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public ClusterMetricsConfiguration getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String metricsConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "metricsConfigurations");
        if (metricsConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metricsConfigurations'.", id)));
        }
        return (ClusterMetricsConfiguration)this.getWithResponse(resourceGroupName, clusterName, metricsConfigurationName, Context.NONE).getValue();
    }

    @Override
    public Response<ClusterMetricsConfiguration> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String metricsConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "metricsConfigurations");
        if (metricsConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metricsConfigurations'.", id)));
        }
        return this.getWithResponse(resourceGroupName, clusterName, metricsConfigurationName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String metricsConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "metricsConfigurations");
        if (metricsConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metricsConfigurations'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, clusterName, metricsConfigurationName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String clusterName = ResourceManagerUtils.getValueFromIdByName(id, "clusters");
        if (clusterName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'clusters'.", id)));
        }
        String metricsConfigurationName = ResourceManagerUtils.getValueFromIdByName(id, "metricsConfigurations");
        if (metricsConfigurationName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'metricsConfigurations'.", id)));
        }
        return this.delete(resourceGroupName, clusterName, metricsConfigurationName, ifMatch, ifNoneMatch, context);
    }

    private MetricsConfigurationsClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public ClusterMetricsConfigurationImpl define(String name) {
        return new ClusterMetricsConfigurationImpl(name, this.manager());
    }
}

