/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.CloudServicesNetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.CloudServicesNetworkImpl;
import com.azure.resourcemanager.networkcloud.implementation.OperationStatusResultImpl;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetwork;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworks;
import com.azure.resourcemanager.networkcloud.models.OperationStatusResult;

public final class CloudServicesNetworksImpl
implements CloudServicesNetworks {
    private static final ClientLogger LOGGER = new ClientLogger(CloudServicesNetworksImpl.class);
    private final CloudServicesNetworksClient innerClient;
    private final NetworkCloudManager serviceManager;

    public CloudServicesNetworksImpl(CloudServicesNetworksClient innerClient, NetworkCloudManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<CloudServicesNetwork> list() {
        PagedIterable<CloudServicesNetworkInner> inner = this.serviceClient().list();
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudServicesNetworkImpl((CloudServicesNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudServicesNetwork> list(Context context) {
        PagedIterable<CloudServicesNetworkInner> inner = this.serviceClient().list(context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudServicesNetworkImpl((CloudServicesNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudServicesNetwork> listByResourceGroup(String resourceGroupName) {
        PagedIterable<CloudServicesNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudServicesNetworkImpl((CloudServicesNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<CloudServicesNetwork> listByResourceGroup(String resourceGroupName, Context context) {
        PagedIterable<CloudServicesNetworkInner> inner = this.serviceClient().listByResourceGroup(resourceGroupName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new CloudServicesNetworkImpl((CloudServicesNetworkInner)((Object)inner1), this.manager()));
    }

    @Override
    public Response<CloudServicesNetwork> getByResourceGroupWithResponse(String resourceGroupName, String cloudServicesNetworkName, Context context) {
        Response<CloudServicesNetworkInner> inner = this.serviceClient().getByResourceGroupWithResponse(resourceGroupName, cloudServicesNetworkName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new CloudServicesNetworkImpl((CloudServicesNetworkInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public CloudServicesNetwork getByResourceGroup(String resourceGroupName, String cloudServicesNetworkName) {
        CloudServicesNetworkInner inner = this.serviceClient().getByResourceGroup(resourceGroupName, cloudServicesNetworkName);
        if (inner != null) {
            return new CloudServicesNetworkImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult deleteByResourceGroup(String resourceGroupName, String cloudServicesNetworkName) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, cloudServicesNetworkName);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public OperationStatusResult delete(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, Context context) {
        OperationStatusResultInner inner = this.serviceClient().delete(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, context);
        if (inner != null) {
            return new OperationStatusResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public CloudServicesNetwork getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudServicesNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "cloudServicesNetworks");
        if (cloudServicesNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudServicesNetworks'.", id)));
        }
        return (CloudServicesNetwork)this.getByResourceGroupWithResponse(resourceGroupName, cloudServicesNetworkName, Context.NONE).getValue();
    }

    @Override
    public Response<CloudServicesNetwork> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudServicesNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "cloudServicesNetworks");
        if (cloudServicesNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudServicesNetworks'.", id)));
        }
        return this.getByResourceGroupWithResponse(resourceGroupName, cloudServicesNetworkName, context);
    }

    @Override
    public OperationStatusResult deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudServicesNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "cloudServicesNetworks");
        if (cloudServicesNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudServicesNetworks'.", id)));
        }
        String localIfMatch = null;
        String localIfNoneMatch = null;
        return this.delete(resourceGroupName, cloudServicesNetworkName, localIfMatch, localIfNoneMatch, Context.NONE);
    }

    @Override
    public OperationStatusResult deleteByIdWithResponse(String id, String ifMatch, String ifNoneMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String cloudServicesNetworkName = ResourceManagerUtils.getValueFromIdByName(id, "cloudServicesNetworks");
        if (cloudServicesNetworkName == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("The resource ID '%s' is not valid. Missing path segment 'cloudServicesNetworks'.", id)));
        }
        return this.delete(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, context);
    }

    private CloudServicesNetworksClient serviceClient() {
        return this.innerClient;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public CloudServicesNetworkImpl define(String name) {
        return new CloudServicesNetworkImpl(name, this.manager());
    }
}

