/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.networkcloud.fluent.CloudServicesNetworksClient;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkInner;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultInner;
import com.azure.resourcemanager.networkcloud.implementation.NetworkCloudImpl;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkList;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkPatchParameters;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class CloudServicesNetworksClientImpl
implements CloudServicesNetworksClient {
    private final CloudServicesNetworksService service;
    private final NetworkCloudImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(CloudServicesNetworksClientImpl.class);

    CloudServicesNetworksClientImpl(NetworkCloudImpl client) {
        this.service = (CloudServicesNetworksService)RestProxy.create(CloudServicesNetworksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudServicesNetworkInner>> listSinglePageAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudServicesNetworkInner> listAsync() {
        return new PagedFlux(() -> this.listSinglePageAsync(), nextLink -> this.listBySubscriptionNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listSinglePage() {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listSinglePage(Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudServicesNetworkInner> list() {
        return new PagedIterable(() -> this.listSinglePage(), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudServicesNetworkInner> list(Context context) {
        return new PagedIterable(() -> this.listSinglePage(context), nextLink -> this.listBySubscriptionNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudServicesNetworkInner>> listByResourceGroupSinglePageAsync(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<CloudServicesNetworkInner> listByResourceGroupAsync(String resourceGroupName) {
        return new PagedFlux(() -> this.listByResourceGroupSinglePageAsync(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listByResourceGroupSinglePage(String resourceGroupName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listByResourceGroupSinglePage(String resourceGroupName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudServicesNetworkInner> listByResourceGroup(String resourceGroupName) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<CloudServicesNetworkInner> listByResourceGroup(String resourceGroupName, Context context) {
        return new PagedIterable(() -> this.listByResourceGroupSinglePage(resourceGroupName, context), nextLink -> this.listByResourceGroupNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<CloudServicesNetworkInner>> getByResourceGroupWithResponseAsync(String resourceGroupName, String cloudServicesNetworkName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getByResourceGroup(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudServicesNetworkInner> getByResourceGroupAsync(String resourceGroupName, String cloudServicesNetworkName) {
        return this.getByResourceGroupWithResponseAsync(resourceGroupName, cloudServicesNetworkName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((CloudServicesNetworkInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CloudServicesNetworkInner> getByResourceGroupWithResponse(String resourceGroupName, String cloudServicesNetworkName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getByResourceGroupSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudServicesNetworkInner getByResourceGroup(String resourceGroupName, String cloudServicesNetworkName) {
        return (CloudServicesNetworkInner)((Object)this.getByResourceGroupWithResponse(resourceGroupName, cloudServicesNetworkName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkParameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServicesNetworkParameters is required and cannot be null."));
        }
        cloudServicesNetworkParameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkParameters is required and cannot be null."));
        }
        cloudServicesNetworkParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkParameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkParameters is required and cannot be null."));
        }
        cloudServicesNetworkParameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginCreateOrUpdateAsync(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginCreateOrUpdateAsync(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginCreateOrUpdate(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginCreateOrUpdate(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginCreateOrUpdate(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudServicesNetworkInner> createOrUpdateAsync(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudServicesNetworkInner> createOrUpdateAsync(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudServicesNetworkInner createOrUpdate(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (CloudServicesNetworkInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudServicesNetworkInner createOrUpdate(String resourceGroupName, String cloudServicesNetworkName, CloudServicesNetworkInner cloudServicesNetworkParameters, String ifMatch, String ifNoneMatch, Context context) {
        return (CloudServicesNetworkInner)((Object)this.beginCreateOrUpdate(resourceGroupName, cloudServicesNetworkName, cloudServicesNetworkParameters, ifMatch, ifNoneMatch, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> deleteWithResponse(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDeleteAsync(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<OperationStatusResultInner>, OperationStatusResultInner> beginDelete(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, Context context) {
        Response<BinaryData> response = this.deleteWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult(response, (Type)((Object)OperationStatusResultInner.class), (Type)((Object)OperationStatusResultInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch) {
        return this.beginDeleteAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<OperationStatusResultInner> deleteAsync(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginDeleteAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public OperationStatusResultInner delete(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, Context context) {
        return (OperationStatusResultInner)this.beginDelete(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkUpdateParameters != null) {
            cloudServicesNetworkUpdateParameters.validate();
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkUpdateParameters != null) {
            cloudServicesNetworkUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> updateWithResponse(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (cloudServicesNetworkName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter cloudServicesNetworkName is required and cannot be null."));
        }
        if (cloudServicesNetworkUpdateParameters != null) {
            cloudServicesNetworkUpdateParameters.validate();
        }
        String accept = "application/json";
        return this.service.updateSync(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginUpdateAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginUpdateAsync(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters = null;
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginUpdate(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginUpdate(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters = null;
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<CloudServicesNetworkInner>, CloudServicesNetworkInner> beginUpdate(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters, Context context) {
        Response<BinaryData> response = this.updateWithResponse(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters, context);
        return this.client.getLroResult(response, (Type)((Object)CloudServicesNetworkInner.class), (Type)((Object)CloudServicesNetworkInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudServicesNetworkInner> updateAsync(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters) {
        return this.beginUpdateAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<CloudServicesNetworkInner> updateAsync(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters = null;
        return this.beginUpdateAsync(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudServicesNetworkInner update(String resourceGroupName, String cloudServicesNetworkName) {
        String ifMatch = null;
        String ifNoneMatch = null;
        CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters = null;
        return (CloudServicesNetworkInner)((Object)this.beginUpdate(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public CloudServicesNetworkInner update(String resourceGroupName, String cloudServicesNetworkName, String ifMatch, String ifNoneMatch, CloudServicesNetworkPatchParameters cloudServicesNetworkUpdateParameters, Context context) {
        return (CloudServicesNetworkInner)((Object)this.beginUpdate(resourceGroupName, cloudServicesNetworkName, ifMatch, ifNoneMatch, cloudServicesNetworkUpdateParameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudServicesNetworkInner>> listBySubscriptionNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listBySubscriptionNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listBySubscriptionNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listBySubscriptionNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listBySubscriptionNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<CloudServicesNetworkInner>> listByResourceGroupNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByResourceGroupNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listByResourceGroupNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<CloudServicesNetworkInner> listByResourceGroupNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<CloudServicesNetworkList> res = this.service.listByResourceGroupNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CloudServicesNetworkList)res.getValue()).value(), ((CloudServicesNetworkList)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkCloudCloudServicesNetworks")
    public static interface CloudServicesNetworksService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/cloudServicesNetworks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudServicesNetworkList>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/providers/Microsoft.NetworkCloud/cloudServicesNetworks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudServicesNetworkList> listSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudServicesNetworkList>> listByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudServicesNetworkList> listByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudServicesNetworkInner>> getByResourceGroup(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudServicesNetworkInner> getByResourceGroupSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") CloudServicesNetworkInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") CloudServicesNetworkInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> deleteSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") CloudServicesNetworkPatchParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkCloud/cloudServicesNetworks/{cloudServicesNetworkName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> updateSync(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="cloudServicesNetworkName") String var5, @HeaderParam(value="If-Match") String var6, @HeaderParam(value="If-None-Match") String var7, @BodyParam(value="application/json") CloudServicesNetworkPatchParameters var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudServicesNetworkList>> listBySubscriptionNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudServicesNetworkList> listBySubscriptionNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<CloudServicesNetworkList>> listByResourceGroupNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<CloudServicesNetworkList> listByResourceGroupNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

