/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.implementation;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.networkcloud.NetworkCloudManager;
import com.azure.resourcemanager.networkcloud.fluent.models.CloudServicesNetworkInner;
import com.azure.resourcemanager.networkcloud.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetwork;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkEnableDefaultEgressEndpoints;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkPatchParameters;
import com.azure.resourcemanager.networkcloud.models.CloudServicesNetworkProvisioningState;
import com.azure.resourcemanager.networkcloud.models.EgressEndpoint;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class CloudServicesNetworkImpl
implements CloudServicesNetwork,
CloudServicesNetwork.Definition,
CloudServicesNetwork.Update {
    private CloudServicesNetworkInner innerObject;
    private final NetworkCloudManager serviceManager;
    private String resourceGroupName;
    private String cloudServicesNetworkName;
    private String createIfMatch;
    private String createIfNoneMatch;
    private String updateIfMatch;
    private String updateIfNoneMatch;
    private CloudServicesNetworkPatchParameters updateCloudServicesNetworkUpdateParameters;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String location() {
        return this.innerModel().location();
    }

    @Override
    public Map<String, String> tags() {
        Map inner = this.innerModel().tags();
        if (inner != null) {
            return Collections.unmodifiableMap(inner);
        }
        return Collections.emptyMap();
    }

    @Override
    public String etag() {
        return this.innerModel().etag();
    }

    @Override
    public ExtendedLocation extendedLocation() {
        return this.innerModel().extendedLocation();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public List<EgressEndpoint> additionalEgressEndpoints() {
        List<EgressEndpoint> inner = this.innerModel().additionalEgressEndpoints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> associatedResourceIds() {
        List<String> inner = this.innerModel().associatedResourceIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String clusterId() {
        return this.innerModel().clusterId();
    }

    @Override
    public CloudServicesNetworkDetailedStatus detailedStatus() {
        return this.innerModel().detailedStatus();
    }

    @Override
    public String detailedStatusMessage() {
        return this.innerModel().detailedStatusMessage();
    }

    @Override
    public CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints() {
        return this.innerModel().enableDefaultEgressEndpoints();
    }

    @Override
    public List<EgressEndpoint> enabledEgressEndpoints() {
        List<EgressEndpoint> inner = this.innerModel().enabledEgressEndpoints();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> hybridAksClustersAssociatedIds() {
        List<String> inner = this.innerModel().hybridAksClustersAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public String interfaceName() {
        return this.innerModel().interfaceName();
    }

    @Override
    public CloudServicesNetworkProvisioningState provisioningState() {
        return this.innerModel().provisioningState();
    }

    @Override
    public List<String> virtualMachinesAssociatedIds() {
        List<String> inner = this.innerModel().virtualMachinesAssociatedIds();
        if (inner != null) {
            return Collections.unmodifiableList(inner);
        }
        return Collections.emptyList();
    }

    @Override
    public Region region() {
        return Region.fromName((String)this.regionName());
    }

    @Override
    public String regionName() {
        return this.location();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public CloudServicesNetworkInner innerModel() {
        return this.innerObject;
    }

    private NetworkCloudManager manager() {
        return this.serviceManager;
    }

    @Override
    public CloudServicesNetworkImpl withExistingResourceGroup(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    @Override
    public CloudServicesNetwork create() {
        this.innerObject = this.serviceManager.serviceClient().getCloudServicesNetworks().createOrUpdate(this.resourceGroupName, this.cloudServicesNetworkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, Context.NONE);
        return this;
    }

    @Override
    public CloudServicesNetwork create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCloudServicesNetworks().createOrUpdate(this.resourceGroupName, this.cloudServicesNetworkName, this.innerModel(), this.createIfMatch, this.createIfNoneMatch, context);
        return this;
    }

    CloudServicesNetworkImpl(String name, NetworkCloudManager serviceManager) {
        this.innerObject = new CloudServicesNetworkInner();
        this.serviceManager = serviceManager;
        this.cloudServicesNetworkName = name;
        this.createIfMatch = null;
        this.createIfNoneMatch = null;
    }

    @Override
    public CloudServicesNetworkImpl update() {
        this.updateIfMatch = null;
        this.updateIfNoneMatch = null;
        this.updateCloudServicesNetworkUpdateParameters = new CloudServicesNetworkPatchParameters();
        return this;
    }

    @Override
    public CloudServicesNetwork apply() {
        this.innerObject = this.serviceManager.serviceClient().getCloudServicesNetworks().update(this.resourceGroupName, this.cloudServicesNetworkName, this.updateIfMatch, this.updateIfNoneMatch, this.updateCloudServicesNetworkUpdateParameters, Context.NONE);
        return this;
    }

    @Override
    public CloudServicesNetwork apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getCloudServicesNetworks().update(this.resourceGroupName, this.cloudServicesNetworkName, this.updateIfMatch, this.updateIfNoneMatch, this.updateCloudServicesNetworkUpdateParameters, context);
        return this;
    }

    CloudServicesNetworkImpl(CloudServicesNetworkInner innerObject, NetworkCloudManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.cloudServicesNetworkName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "cloudServicesNetworks");
    }

    @Override
    public CloudServicesNetwork refresh() {
        this.innerObject = (CloudServicesNetworkInner)((Object)this.serviceManager.serviceClient().getCloudServicesNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.cloudServicesNetworkName, Context.NONE).getValue());
        return this;
    }

    @Override
    public CloudServicesNetwork refresh(Context context) {
        this.innerObject = (CloudServicesNetworkInner)((Object)this.serviceManager.serviceClient().getCloudServicesNetworks().getByResourceGroupWithResponse(this.resourceGroupName, this.cloudServicesNetworkName, context).getValue());
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withRegion(Region location) {
        this.innerModel().withLocation(location.toString());
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withRegion(String location) {
        this.innerModel().withLocation(location);
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withExtendedLocation(ExtendedLocation extendedLocation) {
        this.innerModel().withExtendedLocation(extendedLocation);
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withTags(Map<String, String> tags) {
        if (this.isInCreateMode()) {
            this.innerModel().withTags((Map)tags);
            return this;
        }
        this.updateCloudServicesNetworkUpdateParameters.withTags(tags);
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withAdditionalEgressEndpoints(List<EgressEndpoint> additionalEgressEndpoints) {
        if (this.isInCreateMode()) {
            this.innerModel().withAdditionalEgressEndpoints(additionalEgressEndpoints);
            return this;
        }
        this.updateCloudServicesNetworkUpdateParameters.withAdditionalEgressEndpoints(additionalEgressEndpoints);
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withEnableDefaultEgressEndpoints(CloudServicesNetworkEnableDefaultEgressEndpoints enableDefaultEgressEndpoints) {
        if (this.isInCreateMode()) {
            this.innerModel().withEnableDefaultEgressEndpoints(enableDefaultEgressEndpoints);
            return this;
        }
        this.updateCloudServicesNetworkUpdateParameters.withEnableDefaultEgressEndpoints(enableDefaultEgressEndpoints);
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withIfMatch(String ifMatch) {
        if (this.isInCreateMode()) {
            this.createIfMatch = ifMatch;
            return this;
        }
        this.updateIfMatch = ifMatch;
        return this;
    }

    @Override
    public CloudServicesNetworkImpl withIfNoneMatch(String ifNoneMatch) {
        if (this.isInCreateMode()) {
            this.createIfNoneMatch = ifNoneMatch;
            return this;
        }
        this.updateIfNoneMatch = ifNoneMatch;
        return this;
    }

    private boolean isInCreateMode() {
        return this.innerModel() == null || this.innerModel().id() == null;
    }
}

