/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.RackProperties;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.RackDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.RackProvisioningState;
import java.io.IOException;
import java.util.Map;

public final class RackInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private RackProperties innerProperties = new RackProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(RackInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public RackInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private RackProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public RackInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public RackInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String availabilityZone() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityZone();
    }

    public RackInner withAvailabilityZone(String availabilityZone) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RackProperties();
        }
        this.innerProperties().withAvailabilityZone(availabilityZone);
        return this;
    }

    public String clusterId() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterId();
    }

    public RackDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public RackProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String rackLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().rackLocation();
    }

    public RackInner withRackLocation(String rackLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RackProperties();
        }
        this.innerProperties().withRackLocation(rackLocation);
        return this;
    }

    public String rackSerialNumber() {
        return this.innerProperties() == null ? null : this.innerProperties().rackSerialNumber();
    }

    public RackInner withRackSerialNumber(String rackSerialNumber) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RackProperties();
        }
        this.innerProperties().withRackSerialNumber(rackSerialNumber);
        return this;
    }

    public String rackSkuId() {
        return this.innerProperties() == null ? null : this.innerProperties().rackSkuId();
    }

    public RackInner withRackSkuId(String rackSkuId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RackProperties();
        }
        this.innerProperties().withRackSkuId(rackSkuId);
        return this;
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model RackInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model RackInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static RackInner fromJson(JsonReader jsonReader) throws IOException {
        return (RackInner)((Object)jsonReader.readObject(reader -> {
            RackInner deserializedRackInner = new RackInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRackInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRackInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRackInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRackInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRackInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedRackInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRackInner.innerProperties = RackProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedRackInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedRackInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRackInner;
        }));
    }
}

