/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.OperationStatusResultProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class OperationStatusResultInner
implements JsonSerializable<OperationStatusResultInner> {
    private OffsetDateTime endTime;
    private ManagementError error;
    private String id;
    private String name;
    private List<OperationStatusResultInner> operations;
    private Float percentComplete;
    private OperationStatusResultProperties innerProperties;
    private String resourceId;
    private OffsetDateTime startTime;
    private String status;
    private static final ClientLogger LOGGER = new ClientLogger(OperationStatusResultInner.class);

    public OffsetDateTime endTime() {
        return this.endTime;
    }

    public ManagementError error() {
        return this.error;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public List<OperationStatusResultInner> operations() {
        return this.operations;
    }

    public Float percentComplete() {
        return this.percentComplete;
    }

    private OperationStatusResultProperties innerProperties() {
        return this.innerProperties;
    }

    public String resourceId() {
        return this.resourceId;
    }

    public OffsetDateTime startTime() {
        return this.startTime;
    }

    public String status() {
        return this.status;
    }

    public OperationStatusResultInner withStatus(String status) {
        this.status = status;
        return this;
    }

    public String exitCode() {
        return this.innerProperties() == null ? null : this.innerProperties().exitCode();
    }

    public String outputHead() {
        return this.innerProperties() == null ? null : this.innerProperties().outputHead();
    }

    public String resultRef() {
        return this.innerProperties() == null ? null : this.innerProperties().resultRef();
    }

    public String resultUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().resultUrl();
    }

    public void validate() {
        if (this.operations() != null) {
            this.operations().forEach(e -> e.validate());
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.status() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property status in model OperationStatusResultInner"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static OperationStatusResultInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationStatusResultInner)jsonReader.readObject(reader -> {
            OperationStatusResultInner deserializedOperationStatusResultInner = new OperationStatusResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedOperationStatusResultInner.status = reader.getString();
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedOperationStatusResultInner.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedOperationStatusResultInner.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedOperationStatusResultInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedOperationStatusResultInner.name = reader.getString();
                    continue;
                }
                if ("operations".equals(fieldName)) {
                    List operations;
                    deserializedOperationStatusResultInner.operations = operations = reader.readArray(reader1 -> OperationStatusResultInner.fromJson(reader1));
                    continue;
                }
                if ("percentComplete".equals(fieldName)) {
                    deserializedOperationStatusResultInner.percentComplete = (Float)reader.getNullable(JsonReader::getFloat);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedOperationStatusResultInner.innerProperties = OperationStatusResultProperties.fromJson(reader);
                    continue;
                }
                if ("resourceId".equals(fieldName)) {
                    deserializedOperationStatusResultInner.resourceId = reader.getString();
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedOperationStatusResultInner.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationStatusResultInner;
        });
    }
}

