/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.KubernetesClusterFeatureProperties;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureAvailabilityLifecycle;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureProvisioningState;
import com.azure.resourcemanager.networkcloud.models.KubernetesClusterFeatureRequired;
import com.azure.resourcemanager.networkcloud.models.StringKeyValuePair;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class KubernetesClusterFeatureInner
extends Resource {
    private String etag;
    private KubernetesClusterFeatureProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    private KubernetesClusterFeatureProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public KubernetesClusterFeatureInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public KubernetesClusterFeatureInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public KubernetesClusterFeatureAvailabilityLifecycle availabilityLifecycle() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilityLifecycle();
    }

    public KubernetesClusterFeatureDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public List<StringKeyValuePair> options() {
        return this.innerProperties() == null ? null : this.innerProperties().options();
    }

    public KubernetesClusterFeatureInner withOptions(List<StringKeyValuePair> options) {
        if (this.innerProperties() == null) {
            this.innerProperties = new KubernetesClusterFeatureProperties();
        }
        this.innerProperties().withOptions(options);
        return this;
    }

    public KubernetesClusterFeatureProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public KubernetesClusterFeatureRequired required() {
        return this.innerProperties() == null ? null : this.innerProperties().required();
    }

    public String version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static KubernetesClusterFeatureInner fromJson(JsonReader jsonReader) throws IOException {
        return (KubernetesClusterFeatureInner)((Object)jsonReader.readObject(reader -> {
            KubernetesClusterFeatureInner deserializedKubernetesClusterFeatureInner = new KubernetesClusterFeatureInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedKubernetesClusterFeatureInner.withTags(tags);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.innerProperties = KubernetesClusterFeatureProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedKubernetesClusterFeatureInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKubernetesClusterFeatureInner;
        }));
    }
}

