/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.networkcloud.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.networkcloud.fluent.models.BareMetalMachineKeySetProperties;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetDetailedStatus;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetPrivilegeLevel;
import com.azure.resourcemanager.networkcloud.models.BareMetalMachineKeySetProvisioningState;
import com.azure.resourcemanager.networkcloud.models.ExtendedLocation;
import com.azure.resourcemanager.networkcloud.models.KeySetUser;
import com.azure.resourcemanager.networkcloud.models.KeySetUserStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class BareMetalMachineKeySetInner
extends Resource {
    private String etag;
    private ExtendedLocation extendedLocation;
    private BareMetalMachineKeySetProperties innerProperties = new BareMetalMachineKeySetProperties();
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(BareMetalMachineKeySetInner.class);

    public String etag() {
        return this.etag;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public BareMetalMachineKeySetInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    private BareMetalMachineKeySetProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public BareMetalMachineKeySetInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public BareMetalMachineKeySetInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String azureGroupId() {
        return this.innerProperties() == null ? null : this.innerProperties().azureGroupId();
    }

    public BareMetalMachineKeySetInner withAzureGroupId(String azureGroupId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withAzureGroupId(azureGroupId);
        return this;
    }

    public BareMetalMachineKeySetDetailedStatus detailedStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatus();
    }

    public String detailedStatusMessage() {
        return this.innerProperties() == null ? null : this.innerProperties().detailedStatusMessage();
    }

    public OffsetDateTime expiration() {
        return this.innerProperties() == null ? null : this.innerProperties().expiration();
    }

    public BareMetalMachineKeySetInner withExpiration(OffsetDateTime expiration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withExpiration(expiration);
        return this;
    }

    public List<String> jumpHostsAllowed() {
        return this.innerProperties() == null ? null : this.innerProperties().jumpHostsAllowed();
    }

    public BareMetalMachineKeySetInner withJumpHostsAllowed(List<String> jumpHostsAllowed) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withJumpHostsAllowed(jumpHostsAllowed);
        return this;
    }

    public OffsetDateTime lastValidation() {
        return this.innerProperties() == null ? null : this.innerProperties().lastValidation();
    }

    public String osGroupName() {
        return this.innerProperties() == null ? null : this.innerProperties().osGroupName();
    }

    public BareMetalMachineKeySetInner withOsGroupName(String osGroupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withOsGroupName(osGroupName);
        return this;
    }

    public BareMetalMachineKeySetPrivilegeLevel privilegeLevel() {
        return this.innerProperties() == null ? null : this.innerProperties().privilegeLevel();
    }

    public BareMetalMachineKeySetInner withPrivilegeLevel(BareMetalMachineKeySetPrivilegeLevel privilegeLevel) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withPrivilegeLevel(privilegeLevel);
        return this;
    }

    public BareMetalMachineKeySetProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public List<KeySetUser> userList() {
        return this.innerProperties() == null ? null : this.innerProperties().userList();
    }

    public BareMetalMachineKeySetInner withUserList(List<KeySetUser> userList) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BareMetalMachineKeySetProperties();
        }
        this.innerProperties().withUserList(userList);
        return this;
    }

    public List<KeySetUserStatus> userListStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().userListStatus();
    }

    public void validate() {
        if (this.extendedLocation() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property extendedLocation in model BareMetalMachineKeySetInner"));
        }
        this.extendedLocation().validate();
        if (this.innerProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerProperties in model BareMetalMachineKeySetInner"));
        }
        this.innerProperties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BareMetalMachineKeySetInner fromJson(JsonReader jsonReader) throws IOException {
        return (BareMetalMachineKeySetInner)((Object)jsonReader.readObject(reader -> {
            BareMetalMachineKeySetInner deserializedBareMetalMachineKeySetInner = new BareMetalMachineKeySetInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedBareMetalMachineKeySetInner.withTags(tags);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.innerProperties = BareMetalMachineKeySetProperties.fromJson(reader);
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.etag = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedBareMetalMachineKeySetInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBareMetalMachineKeySetInner;
        }));
    }
}

