/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRestoreBaseResultProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.BackupRestoreOperationStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class BackupResultProperties
extends BackupRestoreBaseResultProperties {
    private String azureStorageBlobContainerUri;
    private String backupId;
    private String jobId;
    private OffsetDateTime endTime;
    private OffsetDateTime startTime;
    private ManagementError error;
    private String statusDetails;
    private BackupRestoreOperationStatus status;

    private BackupResultProperties() {
    }

    public String azureStorageBlobContainerUri() {
        return this.azureStorageBlobContainerUri;
    }

    public String backupId() {
        return this.backupId;
    }

    @Override
    public String jobId() {
        return this.jobId;
    }

    @Override
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    @Override
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    @Override
    public ManagementError error() {
        return this.error;
    }

    @Override
    public String statusDetails() {
        return this.statusDetails;
    }

    @Override
    public BackupRestoreOperationStatus status() {
        return this.status;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("statusDetails", this.statusDetails());
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error());
        jsonWriter.writeStringField("jobId", this.jobId());
        jsonWriter.writeStringField("azureStorageBlobContainerUri", this.azureStorageBlobContainerUri);
        jsonWriter.writeStringField("backupId", this.backupId);
        return jsonWriter.writeEndObject();
    }

    public static BackupResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return (BackupResultProperties)jsonReader.readObject(reader -> {
            BackupResultProperties deserializedBackupResultProperties = new BackupResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    deserializedBackupResultProperties.status = BackupRestoreOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("statusDetails".equals(fieldName)) {
                    deserializedBackupResultProperties.statusDetails = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedBackupResultProperties.error = ManagementError.fromJson((JsonReader)reader);
                    continue;
                }
                if ("startTime".equals(fieldName)) {
                    deserializedBackupResultProperties.startTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("endTime".equals(fieldName)) {
                    deserializedBackupResultProperties.endTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("jobId".equals(fieldName)) {
                    deserializedBackupResultProperties.jobId = reader.getString();
                    continue;
                }
                if ("azureStorageBlobContainerUri".equals(fieldName)) {
                    deserializedBackupResultProperties.azureStorageBlobContainerUri = reader.getString();
                    continue;
                }
                if ("backupId".equals(fieldName)) {
                    deserializedBackupResultProperties.backupId = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupResultProperties;
        });
    }
}

