/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.hardwaresecuritymodules.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterProperties;
import com.azure.resourcemanager.hardwaresecuritymodules.models.CloudHsmClusterSku;
import com.azure.resourcemanager.hardwaresecuritymodules.models.ManagedServiceIdentity;
import java.io.IOException;
import java.util.Map;

public final class CloudHsmClusterInner
extends Resource {
    private CloudHsmClusterProperties properties;
    private ManagedServiceIdentity identity;
    private CloudHsmClusterSku sku;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    public CloudHsmClusterProperties properties() {
        return this.properties;
    }

    public CloudHsmClusterInner withProperties(CloudHsmClusterProperties properties) {
        this.properties = properties;
        return this;
    }

    public ManagedServiceIdentity identity() {
        return this.identity;
    }

    public CloudHsmClusterInner withIdentity(ManagedServiceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public CloudHsmClusterSku sku() {
        return this.sku;
    }

    public CloudHsmClusterInner withSku(CloudHsmClusterSku sku) {
        this.sku = sku;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public CloudHsmClusterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CloudHsmClusterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        return jsonWriter.writeEndObject();
    }

    public static CloudHsmClusterInner fromJson(JsonReader jsonReader) throws IOException {
        return (CloudHsmClusterInner)((Object)jsonReader.readObject(reader -> {
            CloudHsmClusterInner deserializedCloudHsmClusterInner = new CloudHsmClusterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloudHsmClusterInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.properties = CloudHsmClusterProperties.fromJson(reader);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.identity = ManagedServiceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.sku = CloudHsmClusterSku.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCloudHsmClusterInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudHsmClusterInner;
        }));
    }
}

