/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.containerinstance.models.Container;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupDiagnostics;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupIdentity;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupNetworkProfile;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupPropertiesInstanceView;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupRestartPolicy;
import com.azure.resourcemanager.containerinstance.models.ContainerGroupSku;
import com.azure.resourcemanager.containerinstance.models.DnsConfiguration;
import com.azure.resourcemanager.containerinstance.models.EncryptionProperties;
import com.azure.resourcemanager.containerinstance.models.ImageRegistryCredential;
import com.azure.resourcemanager.containerinstance.models.InitContainerDefinition;
import com.azure.resourcemanager.containerinstance.models.IpAddress;
import com.azure.resourcemanager.containerinstance.models.OperatingSystemTypes;
import com.azure.resourcemanager.containerinstance.models.Volume;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

@JsonFlatten
public class ContainerGroupInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ContainerGroupInner.class);
    @JsonProperty(value="identity")
    private ContainerGroupIdentity identity;
    @JsonProperty(value="properties.provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="properties.containers", required=true)
    private List<Container> containers;
    @JsonProperty(value="properties.imageRegistryCredentials")
    private List<ImageRegistryCredential> imageRegistryCredentials;
    @JsonProperty(value="properties.restartPolicy")
    private ContainerGroupRestartPolicy restartPolicy;
    @JsonProperty(value="properties.ipAddress")
    private IpAddress ipAddress;
    @JsonProperty(value="properties.osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="properties.volumes")
    private List<Volume> volumes;
    @JsonProperty(value="properties.instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private ContainerGroupPropertiesInstanceView instanceView;
    @JsonProperty(value="properties.diagnostics")
    private ContainerGroupDiagnostics diagnostics;
    @JsonProperty(value="properties.networkProfile")
    private ContainerGroupNetworkProfile networkProfile;
    @JsonProperty(value="properties.dnsConfig")
    private DnsConfiguration dnsConfig;
    @JsonProperty(value="properties.sku")
    private ContainerGroupSku sku;
    @JsonProperty(value="properties.encryptionProperties")
    private EncryptionProperties encryptionProperties;
    @JsonProperty(value="properties.initContainers")
    private List<InitContainerDefinition> initContainers;

    public ContainerGroupIdentity identity() {
        return this.identity;
    }

    public ContainerGroupInner withIdentity(ContainerGroupIdentity identity) {
        this.identity = identity;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public List<Container> containers() {
        return this.containers;
    }

    public ContainerGroupInner withContainers(List<Container> containers) {
        this.containers = containers;
        return this;
    }

    public List<ImageRegistryCredential> imageRegistryCredentials() {
        return this.imageRegistryCredentials;
    }

    public ContainerGroupInner withImageRegistryCredentials(List<ImageRegistryCredential> imageRegistryCredentials) {
        this.imageRegistryCredentials = imageRegistryCredentials;
        return this;
    }

    public ContainerGroupRestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    public ContainerGroupInner withRestartPolicy(ContainerGroupRestartPolicy restartPolicy) {
        this.restartPolicy = restartPolicy;
        return this;
    }

    public IpAddress ipAddress() {
        return this.ipAddress;
    }

    public ContainerGroupInner withIpAddress(IpAddress ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public ContainerGroupInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public List<Volume> volumes() {
        return this.volumes;
    }

    public ContainerGroupInner withVolumes(List<Volume> volumes) {
        this.volumes = volumes;
        return this;
    }

    public ContainerGroupPropertiesInstanceView instanceView() {
        return this.instanceView;
    }

    public ContainerGroupDiagnostics diagnostics() {
        return this.diagnostics;
    }

    public ContainerGroupInner withDiagnostics(ContainerGroupDiagnostics diagnostics) {
        this.diagnostics = diagnostics;
        return this;
    }

    public ContainerGroupNetworkProfile networkProfile() {
        return this.networkProfile;
    }

    public ContainerGroupInner withNetworkProfile(ContainerGroupNetworkProfile networkProfile) {
        this.networkProfile = networkProfile;
        return this;
    }

    public DnsConfiguration dnsConfig() {
        return this.dnsConfig;
    }

    public ContainerGroupInner withDnsConfig(DnsConfiguration dnsConfig) {
        this.dnsConfig = dnsConfig;
        return this;
    }

    public ContainerGroupSku sku() {
        return this.sku;
    }

    public ContainerGroupInner withSku(ContainerGroupSku sku) {
        this.sku = sku;
        return this;
    }

    public EncryptionProperties encryptionProperties() {
        return this.encryptionProperties;
    }

    public ContainerGroupInner withEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
        return this;
    }

    public List<InitContainerDefinition> initContainers() {
        return this.initContainers;
    }

    public ContainerGroupInner withInitContainers(List<InitContainerDefinition> initContainers) {
        this.initContainers = initContainers;
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.containers() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property containers in model ContainerGroupInner"));
        }
        this.containers().forEach(e -> e.validate());
        if (this.imageRegistryCredentials() != null) {
            this.imageRegistryCredentials().forEach(e -> e.validate());
        }
        if (this.ipAddress() != null) {
            this.ipAddress().validate();
        }
        if (this.osType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osType in model ContainerGroupInner"));
        }
        if (this.volumes() != null) {
            this.volumes().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.diagnostics() != null) {
            this.diagnostics().validate();
        }
        if (this.networkProfile() != null) {
            this.networkProfile().validate();
        }
        if (this.dnsConfig() != null) {
            this.dnsConfig().validate();
        }
        if (this.encryptionProperties() != null) {
            this.encryptionProperties().validate();
        }
        if (this.initContainers() != null) {
            this.initContainers().forEach(e -> e.validate());
        }
    }
}

