/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.containerinstance.fluent.models;

import com.azure.resourcemanager.containerinstance.models.EnvironmentVariable;
import com.azure.resourcemanager.containerinstance.models.InitContainerPropertiesDefinitionInstanceView;
import com.azure.resourcemanager.containerinstance.models.VolumeMount;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class InitContainerPropertiesDefinition {
    @JsonProperty(value="image")
    private String image;
    @JsonProperty(value="command")
    private List<String> command;
    @JsonProperty(value="environmentVariables")
    private List<EnvironmentVariable> environmentVariables;
    @JsonProperty(value="instanceView", access=JsonProperty.Access.WRITE_ONLY)
    private InitContainerPropertiesDefinitionInstanceView instanceView;
    @JsonProperty(value="volumeMounts")
    private List<VolumeMount> volumeMounts;

    public String image() {
        return this.image;
    }

    public InitContainerPropertiesDefinition withImage(String image) {
        this.image = image;
        return this;
    }

    public List<String> command() {
        return this.command;
    }

    public InitContainerPropertiesDefinition withCommand(List<String> command) {
        this.command = command;
        return this;
    }

    public List<EnvironmentVariable> environmentVariables() {
        return this.environmentVariables;
    }

    public InitContainerPropertiesDefinition withEnvironmentVariables(List<EnvironmentVariable> environmentVariables) {
        this.environmentVariables = environmentVariables;
        return this;
    }

    public InitContainerPropertiesDefinitionInstanceView instanceView() {
        return this.instanceView;
    }

    public List<VolumeMount> volumeMounts() {
        return this.volumeMounts;
    }

    public InitContainerPropertiesDefinition withVolumeMounts(List<VolumeMount> volumeMounts) {
        this.volumeMounts = volumeMounts;
        return this;
    }

    public void validate() {
        if (this.environmentVariables() != null) {
            this.environmentVariables().forEach(e -> e.validate());
        }
        if (this.instanceView() != null) {
            this.instanceView().validate();
        }
        if (this.volumeMounts() != null) {
            this.volumeMounts().forEach(e -> e.validate());
        }
    }
}

