/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersTodosClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfTodoTaskList;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTodoTaskListInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoExpand;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class UsersTodosClientImpl
implements UsersTodosClient {
    private final ClientLogger logger = new ClientLogger(UsersTodosClientImpl.class);
    private final UsersTodosService service;
    private final MicrosoftGraphClientImpl client;

    UsersTodosClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersTodosService)RestProxy.create(UsersTodosService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskListInner>> listListsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoOrderby> orderby, List<UsersTodoSelect> select, List<UsersTodoExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listLists(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTaskList)res.getValue()).value(), ((CollectionOfTodoTaskList)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskListInner>> listListsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoOrderby> orderby, List<UsersTodoSelect> select, List<UsersTodoExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listLists(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTaskList)res.getValue()).value(), ((CollectionOfTodoTaskList)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphTodoTaskListInner> listListsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoOrderby> orderby, List<UsersTodoSelect> select, List<UsersTodoExpand> expand) {
        return new PagedFlux(() -> this.listListsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphTodoTaskListInner> listListsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listListsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphTodoTaskListInner> listListsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoOrderby> orderby, List<UsersTodoSelect> select, List<UsersTodoExpand> expand, Context context) {
        return new PagedFlux(() -> this.listListsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphTodoTaskListInner> listLists(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersTodoOrderby> orderby = null;
        List<UsersTodoSelect> select = null;
        List<UsersTodoExpand> expand = null;
        return new PagedIterable(this.listListsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphTodoTaskListInner> listLists(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoOrderby> orderby, List<UsersTodoSelect> select, List<UsersTodoExpand> expand, Context context) {
        return new PagedIterable(this.listListsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphTodoTaskListInner>> createListsWithResponseAsync(String userId, MicrosoftGraphTodoTaskListInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createLists(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphTodoTaskListInner>> createListsWithResponseAsync(String userId, MicrosoftGraphTodoTaskListInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createLists(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskListInner> createListsAsync(String userId, MicrosoftGraphTodoTaskListInner body) {
        return this.createListsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskListInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphTodoTaskListInner createLists(String userId, MicrosoftGraphTodoTaskListInner body) {
        return (MicrosoftGraphTodoTaskListInner)this.createListsAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphTodoTaskListInner> createListsWithResponse(String userId, MicrosoftGraphTodoTaskListInner body, Context context) {
        return (Response)this.createListsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphTodoTaskListInner>> getListsWithResponseAsync(String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getLists(this.client.getEndpoint(), userId, todoTaskListId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphTodoTaskListInner>> getListsWithResponseAsync(String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getLists(this.client.getEndpoint(), userId, todoTaskListId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskListInner> getListsAsync(String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand) {
        return this.getListsWithResponseAsync(userId, todoTaskListId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskListInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskListInner> getListsAsync(String userId, String todoTaskListId) {
        List<UsersTodoSelect> select = null;
        List<UsersTodoExpand> expand = null;
        return this.getListsWithResponseAsync(userId, todoTaskListId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskListInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphTodoTaskListInner getLists(String userId, String todoTaskListId) {
        List<UsersTodoSelect> select = null;
        List<UsersTodoExpand> expand = null;
        return (MicrosoftGraphTodoTaskListInner)this.getListsAsync(userId, todoTaskListId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphTodoTaskListInner> getListsWithResponse(String userId, String todoTaskListId, List<UsersTodoSelect> select, List<UsersTodoExpand> expand, Context context) {
        return (Response)this.getListsWithResponseAsync(userId, todoTaskListId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateListsWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateLists(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateListsWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateLists(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateListsAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body) {
        return this.updateListsWithResponseAsync(userId, todoTaskListId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateLists(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body) {
        this.updateListsAsync(userId, todoTaskListId, body).block();
    }

    @Override
    public Response<Void> updateListsWithResponse(String userId, String todoTaskListId, MicrosoftGraphTodoTaskListInner body, Context context) {
        return (Response)this.updateListsWithResponseAsync(userId, todoTaskListId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteListsWithResponseAsync(String userId, String todoTaskListId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteLists(this.client.getEndpoint(), userId, todoTaskListId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteListsWithResponseAsync(String userId, String todoTaskListId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteLists(this.client.getEndpoint(), userId, todoTaskListId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteListsAsync(String userId, String todoTaskListId, String ifMatch) {
        return this.deleteListsWithResponseAsync(userId, todoTaskListId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteListsAsync(String userId, String todoTaskListId) {
        String ifMatch = null;
        return this.deleteListsWithResponseAsync(userId, todoTaskListId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteLists(String userId, String todoTaskListId) {
        String ifMatch = null;
        this.deleteListsAsync(userId, todoTaskListId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteListsWithResponse(String userId, String todoTaskListId, String ifMatch, Context context) {
        return (Response)this.deleteListsWithResponseAsync(userId, todoTaskListId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskListInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTaskList)res.getValue()).value(), ((CollectionOfTodoTaskList)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskListInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTaskList)res.getValue()).value(), ((CollectionOfTodoTaskList)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersTodosService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTodoTaskList>> listLists(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/todo/lists")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphTodoTaskListInner>> createLists(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphTodoTaskListInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphTodoTaskListInner>> getLists(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo/lists/{todoTaskList-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateLists(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @BodyParam(value="application/json") MicrosoftGraphTodoTaskListInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo/lists/{todoTaskList-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteLists(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTodoTaskList>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

