/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersTodoListsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension0;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfTodoTask;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTodoTaskInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsExpand;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersTodoListsSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class UsersTodoListsClientImpl
implements UsersTodoListsClient {
    private final ClientLogger logger = new ClientLogger(UsersTodoListsClientImpl.class);
    private final UsersTodoListsService service;
    private final MicrosoftGraphClientImpl client;

    UsersTodoListsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersTodoListsService)RestProxy.create(UsersTodoListsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), userId, todoTaskListId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), userId, todoTaskListId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersTodoListsOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(userId, todoTaskListId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner createExtensions(String userId, String todoTaskListId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(userId, todoTaskListId, body).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String userId, String todoTaskListId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(userId, todoTaskListId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand) {
        return this.getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String todoTaskListId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return this.getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner getExtensions(String userId, String todoTaskListId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(userId, todoTaskListId, extensionId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String userId, String todoTaskListId, String extensionId, List<String> select, List<String> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateExtensionsAsync(String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateExtensions(String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(userId, todoTaskListId, extensionId, body).block();
    }

    @Override
    public Response<Void> updateExtensionsWithResponse(String userId, String todoTaskListId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String todoTaskListId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), userId, todoTaskListId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String todoTaskListId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteExtensions(String userId, String todoTaskListId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(userId, todoTaskListId, extensionId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteExtensionsWithResponse(String userId, String todoTaskListId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(userId, todoTaskListId, extensionId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksSinglePageAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTasks(this.client.getEndpoint(), userId, todoTaskListId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTask)res.getValue()).value(), ((CollectionOfTodoTask)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksSinglePageAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTasks(this.client.getEndpoint(), userId, todoTaskListId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTask)res.getValue()).value(), ((CollectionOfTodoTask)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand) {
        return new PagedFlux(() -> this.listTasksSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTasksNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(String userId, String todoTaskListId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTasksSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTasksNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphTodoTaskInner> listTasksAsync(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand, Context context) {
        return new PagedFlux(() -> this.listTasksSinglePageAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTasksNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphTodoTaskInner> listTasks(String userId, String todoTaskListId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersTodoListsOrderby> orderby = null;
        List<UsersTodoListsSelect> select = null;
        List<UsersTodoListsExpand> expand = null;
        return new PagedIterable(this.listTasksAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphTodoTaskInner> listTasks(String userId, String todoTaskListId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersTodoListsOrderby> orderby, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand, Context context) {
        return new PagedIterable(this.listTasksAsync(userId, todoTaskListId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphTodoTaskInner>> createTasksWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createTasks(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphTodoTaskInner>> createTasksWithResponseAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createTasks(this.client.getEndpoint(), userId, todoTaskListId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskInner> createTasksAsync(String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        return this.createTasksWithResponseAsync(userId, todoTaskListId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphTodoTaskInner createTasks(String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body) {
        return (MicrosoftGraphTodoTaskInner)this.createTasksAsync(userId, todoTaskListId, body).block();
    }

    @Override
    public Response<MicrosoftGraphTodoTaskInner> createTasksWithResponse(String userId, String todoTaskListId, MicrosoftGraphTodoTaskInner body, Context context) {
        return (Response)this.createTasksWithResponseAsync(userId, todoTaskListId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphTodoTaskInner>> getTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphTodoTaskInner>> getTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskInner> getTasksAsync(String userId, String todoTaskListId, String todoTaskId, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand) {
        return this.getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphTodoTaskInner> getTasksAsync(String userId, String todoTaskListId, String todoTaskId) {
        List<UsersTodoListsSelect> select = null;
        List<UsersTodoListsExpand> expand = null;
        return this.getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoTaskInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphTodoTaskInner getTasks(String userId, String todoTaskListId, String todoTaskId) {
        List<UsersTodoListsSelect> select = null;
        List<UsersTodoListsExpand> expand = null;
        return (MicrosoftGraphTodoTaskInner)this.getTasksAsync(userId, todoTaskListId, todoTaskId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphTodoTaskInner> getTasksWithResponse(String userId, String todoTaskListId, String todoTaskId, List<UsersTodoListsSelect> select, List<UsersTodoListsExpand> expand, Context context) {
        return (Response)this.getTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateTasksAsync(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        return this.updateTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateTasks(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body) {
        this.updateTasksAsync(userId, todoTaskListId, todoTaskId, body).block();
    }

    @Override
    public Response<Void> updateTasksWithResponse(String userId, String todoTaskListId, String todoTaskId, MicrosoftGraphTodoTaskInner body, Context context) {
        return (Response)this.updateTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteTasksWithResponseAsync(String userId, String todoTaskListId, String todoTaskId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (todoTaskListId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskListId is required and cannot be null."));
        }
        if (todoTaskId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter todoTaskId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteTasks(this.client.getEndpoint(), userId, todoTaskListId, todoTaskId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteTasksAsync(String userId, String todoTaskListId, String todoTaskId, String ifMatch) {
        return this.deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteTasksAsync(String userId, String todoTaskListId, String todoTaskId) {
        String ifMatch = null;
        return this.deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteTasks(String userId, String todoTaskListId, String todoTaskId) {
        String ifMatch = null;
        this.deleteTasksAsync(userId, todoTaskListId, todoTaskId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteTasksWithResponse(String userId, String todoTaskListId, String todoTaskId, String ifMatch, Context context) {
        return (Response)this.deleteTasksWithResponseAsync(userId, todoTaskListId, todoTaskId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension0)res.getValue()).value(), ((CollectionOfExtension0)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTasksNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTask)res.getValue()).value(), ((CollectionOfTodoTask)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphTodoTaskInner>> listTasksNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTasksNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfTodoTask)res.getValue()).value(), ((CollectionOfTodoTask)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersTodoListsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension0>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$skip") Integer var5, @QueryParam(value="$search") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$count") Boolean var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="$select") String var10, @QueryParam(value="$expand") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/todo/lists/{todoTaskList-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="extension-id") String var4, @QueryParam(value="$select") String var5, @QueryParam(value="$expand") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="extension-id") String var4, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo/lists/{todoTaskList-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="extension-id") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTodoTask>> listTasks(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="$skip") Integer var5, @QueryParam(value="$search") String var6, @QueryParam(value="$filter") String var7, @QueryParam(value="$count") Boolean var8, @QueryParam(value="$orderby") String var9, @QueryParam(value="$select") String var10, @QueryParam(value="$expand") String var11, @HeaderParam(value="Accept") String var12, Context var13);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphTodoTaskInner>> createTasks(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @BodyParam(value="application/json") MicrosoftGraphTodoTaskInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphTodoTaskInner>> getTasks(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @QueryParam(value="$select") String var5, @QueryParam(value="$expand") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateTasks(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @BodyParam(value="application/json") MicrosoftGraphTodoTaskInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo/lists/{todoTaskList-id}/tasks/{todoTask-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteTasks(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="todoTaskList-id") String var3, @PathParam(value="todoTask-id") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension0>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfTodoTask>> listTasksNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

