/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.http.rest.StreamResponse;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.UsersClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfAppRoleAssignment2;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject0AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject1AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject2AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject3AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject4AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObject5;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfDirectoryObjectAutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfExtension;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLicenseDetails;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject0AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject1AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject2AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject3AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject4AutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObject5;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfDirectoryObjectAutoGenerated;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfLinksOfOAuth2PermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfOAuth2PermissionGrant;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfProfilePhoto;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfScopedRoleMembership1;
import com.azure.resourcemanager.authorization.fluent.models.Get1ItemsItem;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphAppRoleAssignmentInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDirectoryObjectInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphExtensionInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphLicenseDetailsInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOAuth2PermissionGrantInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphOutlookUserInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphProfilePhotoInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphScopedRoleMembershipInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphTodoInner;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphUserSettingsInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.UsersExpand;
import com.azure.resourcemanager.authorization.fluent.models.UsersOrderby;
import com.azure.resourcemanager.authorization.fluent.models.UsersSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import com.fasterxml.jackson.databind.util.ByteBufferBackedInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class UsersClientImpl
implements UsersClient {
    private final ClientLogger logger = new ClientLogger(UsersClientImpl.class);
    private final UsersService service;
    private final MicrosoftGraphClientImpl client;

    UsersClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (UsersService)RestProxy.create(UsersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listAppRoleAssignments(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment2)res.getValue()).value(), ((CollectionOfAppRoleAssignment2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listAppRoleAssignmentsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listAppRoleAssignments(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment2)res.getValue()).value(), ((CollectionOfAppRoleAssignment2)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignmentsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listAppRoleAssignmentsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listAppRoleAssignmentsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphAppRoleAssignmentInner> listAppRoleAssignments(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listAppRoleAssignmentsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String userId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createAppRoleAssignments(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignmentsWithResponseAsync(String userId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createAppRoleAssignments(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsAsync(String userId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.createAppRoleAssignmentsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphAppRoleAssignmentInner createAppRoleAssignments(String userId, MicrosoftGraphAppRoleAssignmentInner body) {
        return (MicrosoftGraphAppRoleAssignmentInner)this.createAppRoleAssignmentsAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphAppRoleAssignmentInner> createAppRoleAssignmentsWithResponse(String userId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.createAppRoleAssignmentsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String userId, String appRoleAssignmentId, List<UsersSelect> select, List<String> expand) {
        return this.getAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsAsync(String userId, String appRoleAssignmentId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return this.getAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphAppRoleAssignmentInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphAppRoleAssignmentInner getAppRoleAssignments(String userId, String appRoleAssignmentId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphAppRoleAssignmentInner)this.getAppRoleAssignmentsAsync(userId, appRoleAssignmentId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphAppRoleAssignmentInner> getAppRoleAssignmentsWithResponse(String userId, String appRoleAssignmentId, List<UsersSelect> select, List<String> expand, Context context) {
        return (Response)this.getAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateAppRoleAssignmentsAsync(String userId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        return this.updateAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateAppRoleAssignments(String userId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body) {
        this.updateAppRoleAssignmentsAsync(userId, appRoleAssignmentId, body).block();
    }

    @Override
    public Response<Void> updateAppRoleAssignmentsWithResponse(String userId, String appRoleAssignmentId, MicrosoftGraphAppRoleAssignmentInner body, Context context) {
        return (Response)this.updateAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteAppRoleAssignmentsWithResponseAsync(String userId, String appRoleAssignmentId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (appRoleAssignmentId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter appRoleAssignmentId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteAppRoleAssignments(this.client.getEndpoint(), userId, appRoleAssignmentId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteAppRoleAssignmentsAsync(String userId, String appRoleAssignmentId, String ifMatch) {
        return this.deleteAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteAppRoleAssignmentsAsync(String userId, String appRoleAssignmentId) {
        String ifMatch = null;
        return this.deleteAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteAppRoleAssignments(String userId, String appRoleAssignmentId) {
        String ifMatch = null;
        this.deleteAppRoleAssignmentsAsync(userId, appRoleAssignmentId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteAppRoleAssignmentsWithResponse(String userId, String appRoleAssignmentId, String ifMatch, Context context) {
        return (Response)this.deleteAppRoleAssignmentsWithResponseAsync(userId, appRoleAssignmentId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listCreatedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listCreatedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listCreatedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listCreatedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listCreatedObjectsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listCreatedObjects(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listCreatedObjectsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefCreatedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefCreatedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefCreatedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefCreatedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefCreatedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefCreatedObjectsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefCreatedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefCreatedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefCreatedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefCreatedObjects(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefCreatedObjectsAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefCreatedObjects(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefCreatedObjectsAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefCreatedObjectsWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefCreatedObjects(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefCreatedObjectsWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefCreatedObjects(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefCreatedObjectsAsync(String userId, Map<String, Object> body) {
        return this.createRefCreatedObjectsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefCreatedObjects(String userId, Map<String, Object> body) {
        return (Map)this.createRefCreatedObjectsAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefCreatedObjectsWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefCreatedObjectsWithResponseAsync(userId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listDirectReports(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listDirectReports(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDirectReportsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listDirectReportsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listDirectReportsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listDirectReportsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listDirectReportsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listDirectReports(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listDirectReportsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefDirectReports(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefDirectReports(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefDirectReportsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefDirectReportsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefDirectReportsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefDirectReportsSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefDirectReportsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefDirectReports(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefDirectReportsAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefDirectReports(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefDirectReportsAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefDirectReports(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefDirectReportsWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefDirectReports(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefDirectReportsAsync(String userId, Map<String, Object> body) {
        return this.createRefDirectReportsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefDirectReports(String userId, Map<String, Object> body) {
        return (Map)this.createRefDirectReportsAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefDirectReportsWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefDirectReportsWithResponseAsync(userId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listExtensions(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listExtensions(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<String> select, List<String> expand) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphExtensionInner> listExtensionsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listExtensionsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listExtensionsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<String> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listExtensionsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphExtensionInner> listExtensions(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<String> select, List<String> expand, Context context) {
        return new PagedIterable(this.listExtensionsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createExtensions(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> createExtensionsWithResponseAsync(String userId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createExtensions(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> createExtensionsAsync(String userId, MicrosoftGraphExtensionInner body) {
        return this.createExtensionsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner createExtensions(String userId, MicrosoftGraphExtensionInner body) {
        return (MicrosoftGraphExtensionInner)this.createExtensionsAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> createExtensionsWithResponse(String userId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.createExtensionsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String extensionId, List<String> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getExtensions(this.client.getEndpoint(), userId, extensionId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphExtensionInner>> getExtensionsWithResponseAsync(String userId, String extensionId, List<String> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getExtensions(this.client.getEndpoint(), userId, extensionId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String extensionId, List<String> select, List<String> expand) {
        return this.getExtensionsWithResponseAsync(userId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphExtensionInner> getExtensionsAsync(String userId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return this.getExtensionsWithResponseAsync(userId, extensionId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphExtensionInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphExtensionInner getExtensions(String userId, String extensionId) {
        List<String> select = null;
        List<String> expand = null;
        return (MicrosoftGraphExtensionInner)this.getExtensionsAsync(userId, extensionId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphExtensionInner> getExtensionsWithResponse(String userId, String extensionId, List<String> select, List<String> expand, Context context) {
        return (Response)this.getExtensionsWithResponseAsync(userId, extensionId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String extensionId, MicrosoftGraphExtensionInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateExtensions(this.client.getEndpoint(), userId, extensionId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateExtensionsWithResponseAsync(String userId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateExtensions(this.client.getEndpoint(), userId, extensionId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateExtensionsAsync(String userId, String extensionId, MicrosoftGraphExtensionInner body) {
        return this.updateExtensionsWithResponseAsync(userId, extensionId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateExtensions(String userId, String extensionId, MicrosoftGraphExtensionInner body) {
        this.updateExtensionsAsync(userId, extensionId, body).block();
    }

    @Override
    public Response<Void> updateExtensionsWithResponse(String userId, String extensionId, MicrosoftGraphExtensionInner body, Context context) {
        return (Response)this.updateExtensionsWithResponseAsync(userId, extensionId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String extensionId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteExtensions(this.client.getEndpoint(), userId, extensionId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteExtensionsWithResponseAsync(String userId, String extensionId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (extensionId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter extensionId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteExtensions(this.client.getEndpoint(), userId, extensionId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String extensionId, String ifMatch) {
        return this.deleteExtensionsWithResponseAsync(userId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteExtensionsAsync(String userId, String extensionId) {
        String ifMatch = null;
        return this.deleteExtensionsWithResponseAsync(userId, extensionId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteExtensions(String userId, String extensionId) {
        String ifMatch = null;
        this.deleteExtensionsAsync(userId, extensionId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteExtensionsWithResponse(String userId, String extensionId, String ifMatch, Context context) {
        return (Response)this.deleteExtensionsWithResponseAsync(userId, extensionId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphLicenseDetailsInner>> listLicenseDetailsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listLicenseDetails(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLicenseDetails)res.getValue()).value(), ((CollectionOfLicenseDetails)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphLicenseDetailsInner>> listLicenseDetailsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listLicenseDetails(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLicenseDetails)res.getValue()).value(), ((CollectionOfLicenseDetails)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphLicenseDetailsInner> listLicenseDetailsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listLicenseDetailsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listLicenseDetailsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphLicenseDetailsInner> listLicenseDetailsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listLicenseDetailsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listLicenseDetailsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphLicenseDetailsInner> listLicenseDetailsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listLicenseDetailsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listLicenseDetailsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphLicenseDetailsInner> listLicenseDetails(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listLicenseDetailsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphLicenseDetailsInner> listLicenseDetails(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listLicenseDetailsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphLicenseDetailsInner>> createLicenseDetailsWithResponseAsync(String userId, MicrosoftGraphLicenseDetailsInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createLicenseDetails(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphLicenseDetailsInner>> createLicenseDetailsWithResponseAsync(String userId, MicrosoftGraphLicenseDetailsInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createLicenseDetails(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphLicenseDetailsInner> createLicenseDetailsAsync(String userId, MicrosoftGraphLicenseDetailsInner body) {
        return this.createLicenseDetailsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLicenseDetailsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphLicenseDetailsInner createLicenseDetails(String userId, MicrosoftGraphLicenseDetailsInner body) {
        return (MicrosoftGraphLicenseDetailsInner)this.createLicenseDetailsAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphLicenseDetailsInner> createLicenseDetailsWithResponse(String userId, MicrosoftGraphLicenseDetailsInner body, Context context) {
        return (Response)this.createLicenseDetailsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphLicenseDetailsInner>> getLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphLicenseDetailsInner>> getLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphLicenseDetailsInner> getLicenseDetailsAsync(String userId, String licenseDetailsId, List<UsersSelect> select, List<String> expand) {
        return this.getLicenseDetailsWithResponseAsync(userId, licenseDetailsId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLicenseDetailsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphLicenseDetailsInner> getLicenseDetailsAsync(String userId, String licenseDetailsId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return this.getLicenseDetailsWithResponseAsync(userId, licenseDetailsId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphLicenseDetailsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphLicenseDetailsInner getLicenseDetails(String userId, String licenseDetailsId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphLicenseDetailsInner)this.getLicenseDetailsAsync(userId, licenseDetailsId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphLicenseDetailsInner> getLicenseDetailsWithResponse(String userId, String licenseDetailsId, List<UsersSelect> select, List<String> expand, Context context) {
        return (Response)this.getLicenseDetailsWithResponseAsync(userId, licenseDetailsId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, MicrosoftGraphLicenseDetailsInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, MicrosoftGraphLicenseDetailsInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateLicenseDetailsAsync(String userId, String licenseDetailsId, MicrosoftGraphLicenseDetailsInner body) {
        return this.updateLicenseDetailsWithResponseAsync(userId, licenseDetailsId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateLicenseDetails(String userId, String licenseDetailsId, MicrosoftGraphLicenseDetailsInner body) {
        this.updateLicenseDetailsAsync(userId, licenseDetailsId, body).block();
    }

    @Override
    public Response<Void> updateLicenseDetailsWithResponse(String userId, String licenseDetailsId, MicrosoftGraphLicenseDetailsInner body, Context context) {
        return (Response)this.updateLicenseDetailsWithResponseAsync(userId, licenseDetailsId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteLicenseDetailsWithResponseAsync(String userId, String licenseDetailsId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (licenseDetailsId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter licenseDetailsId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteLicenseDetails(this.client.getEndpoint(), userId, licenseDetailsId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteLicenseDetailsAsync(String userId, String licenseDetailsId, String ifMatch) {
        return this.deleteLicenseDetailsWithResponseAsync(userId, licenseDetailsId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteLicenseDetailsAsync(String userId, String licenseDetailsId) {
        String ifMatch = null;
        return this.deleteLicenseDetailsWithResponseAsync(userId, licenseDetailsId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteLicenseDetails(String userId, String licenseDetailsId) {
        String ifMatch = null;
        this.deleteLicenseDetailsAsync(userId, licenseDetailsId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteLicenseDetailsWithResponse(String userId, String licenseDetailsId, String ifMatch, Context context) {
        return (Response)this.deleteLicenseDetailsWithResponseAsync(userId, licenseDetailsId, ifMatch, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(String userId, List<Get1ItemsItem> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getManager(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManagerWithResponseAsync(String userId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getManager(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(String userId, List<Get1ItemsItem> select, List<String> expand) {
        return this.getManagerWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphDirectoryObjectInner> getManagerAsync(String userId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return this.getManagerWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphDirectoryObjectInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphDirectoryObjectInner getManager(String userId) {
        List<Get1ItemsItem> select = null;
        List<String> expand = null;
        return (MicrosoftGraphDirectoryObjectInner)this.getManagerAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphDirectoryObjectInner> getManagerWithResponse(String userId, List<Get1ItemsItem> select, List<String> expand, Context context) {
        return (Response)this.getManagerWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<String>> getRefManagerWithResponseAsync(String userId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.getRefManager(this.client.getEndpoint(), userId, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<String>> getRefManagerWithResponseAsync(String userId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.getRefManager(this.client.getEndpoint(), userId, "application/json", context);
    }

    @Override
    public Mono<String> getRefManagerAsync(String userId) {
        return this.getRefManagerWithResponseAsync(userId).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((String)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public String getRefManager(String userId) {
        return (String)this.getRefManagerAsync(userId).block();
    }

    @Override
    public Response<String> getRefManagerWithResponse(String userId, Context context) {
        return (Response)this.getRefManagerWithResponseAsync(userId, context).block();
    }

    @Override
    public Mono<Response<Void>> setRefManagerWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setRefManager(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> setRefManagerWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setRefManager(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> setRefManagerAsync(String userId, Map<String, Object> body) {
        return this.setRefManagerWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void setRefManager(String userId, Map<String, Object> body) {
        this.setRefManagerAsync(userId, body).block();
    }

    @Override
    public Response<Void> setRefManagerWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.setRefManagerWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteRefManagerWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteRefManager(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteRefManagerWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteRefManager(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteRefManagerAsync(String userId, String ifMatch) {
        return this.deleteRefManagerWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteRefManagerAsync(String userId) {
        String ifMatch = null;
        return this.deleteRefManagerWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteRefManager(String userId) {
        String ifMatch = null;
        this.deleteRefManagerAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteRefManagerWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deleteRefManagerWithResponseAsync(userId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listMemberOf(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefMemberOfAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefMemberOf(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefMemberOfAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefMemberOf(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefMemberOfAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefMemberOf(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefMemberOfWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefMemberOf(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefMemberOfAsync(String userId, Map<String, Object> body) {
        return this.createRefMemberOfWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefMemberOf(String userId, Map<String, Object> body) {
        return (Map)this.createRefMemberOfAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefMemberOfWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefMemberOfWithResponseAsync(userId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOauth2PermissionGrants(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOauth2PermissionGrants(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrantsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOauth2PermissionGrantsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOauth2PermissionGrantsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphOAuth2PermissionGrantInner> listOauth2PermissionGrants(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOauth2PermissionGrantsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOauth2PermissionGrants(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOauth2PermissionGrants(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefOauth2PermissionGrantsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefOauth2PermissionGrantsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefOauth2PermissionGrantsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOauth2PermissionGrantsSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOauth2PermissionGrantsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefOauth2PermissionGrants(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefOauth2PermissionGrantsAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefOauth2PermissionGrants(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOauth2PermissionGrantsAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrantsWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOauth2PermissionGrants(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrantsWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOauth2PermissionGrants(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefOauth2PermissionGrantsAsync(String userId, Map<String, Object> body) {
        return this.createRefOauth2PermissionGrantsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefOauth2PermissionGrants(String userId, Map<String, Object> body) {
        return (Map)this.createRefOauth2PermissionGrantsAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefOauth2PermissionGrantsWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOauth2PermissionGrantsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphOutlookUserInner>> getOutlookWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getOutlook(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphOutlookUserInner>> getOutlookWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getOutlook(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphOutlookUserInner> getOutlookAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        return this.getOutlookWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOutlookUserInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphOutlookUserInner> getOutlookAsync(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return this.getOutlookWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphOutlookUserInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphOutlookUserInner getOutlook(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return (MicrosoftGraphOutlookUserInner)this.getOutlookAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphOutlookUserInner> getOutlookWithResponse(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        return (Response)this.getOutlookWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateOutlookWithResponseAsync(String userId, MicrosoftGraphOutlookUserInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateOutlook(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateOutlookWithResponseAsync(String userId, MicrosoftGraphOutlookUserInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateOutlook(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateOutlookAsync(String userId, MicrosoftGraphOutlookUserInner body) {
        return this.updateOutlookWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateOutlook(String userId, MicrosoftGraphOutlookUserInner body) {
        this.updateOutlookAsync(userId, body).block();
    }

    @Override
    public Response<Void> updateOutlookWithResponse(String userId, MicrosoftGraphOutlookUserInner body, Context context) {
        return (Response)this.updateOutlookWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteOutlookWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteOutlook(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteOutlookWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteOutlook(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteOutlookAsync(String userId, String ifMatch) {
        return this.deleteOutlookWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteOutlookAsync(String userId) {
        String ifMatch = null;
        return this.deleteOutlookWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteOutlook(String userId) {
        String ifMatch = null;
        this.deleteOutlookAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteOutlookWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deleteOutlookWithResponseAsync(userId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOwnedDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOwnedDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedDevicesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedDevicesAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedDevicesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOwnedDevicesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedDevices(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOwnedDevicesAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedDevices(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOwnedDevicesAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefOwnedDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOwnedDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOwnedDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefOwnedDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedDevicesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefOwnedDevicesAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedDevicesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefOwnedDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOwnedDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOwnedDevicesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefOwnedDevices(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefOwnedDevicesAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefOwnedDevices(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOwnedDevicesAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefOwnedDevicesWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOwnedDevices(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefOwnedDevicesWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOwnedDevices(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefOwnedDevicesAsync(String userId, Map<String, Object> body) {
        return this.createRefOwnedDevicesWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefOwnedDevices(String userId, Map<String, Object> body) {
        return (Map)this.createRefOwnedDevicesAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefOwnedDevicesWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOwnedDevicesWithResponseAsync(userId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listOwnedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listOwnedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listOwnedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listOwnedObjectsAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listOwnedObjects(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listOwnedObjectsAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefOwnedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefOwnedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOwnedObjectsSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedObjects(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefOwnedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefOwnedObjectsAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefOwnedObjectsAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefOwnedObjectsSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefOwnedObjectsNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefOwnedObjects(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefOwnedObjectsAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefOwnedObjects(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefOwnedObjectsAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefOwnedObjectsWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefOwnedObjects(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefOwnedObjectsWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefOwnedObjects(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefOwnedObjectsAsync(String userId, Map<String, Object> body) {
        return this.createRefOwnedObjectsWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefOwnedObjects(String userId, Map<String, Object> body) {
        return (Map)this.createRefOwnedObjectsAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefOwnedObjectsWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefOwnedObjectsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(String userId, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getPhoto(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotoWithResponseAsync(String userId, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getPhoto(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(String userId, List<UsersSelect> select, List<String> expand) {
        return this.getPhotoWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotoAsync(String userId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return this.getPhotoWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphProfilePhotoInner getPhoto(String userId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphProfilePhotoInner)this.getPhotoAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphProfilePhotoInner> getPhotoWithResponse(String userId, List<UsersSelect> select, List<String> expand, Context context) {
        return (Response)this.getPhotoWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updatePhotoWithResponseAsync(String userId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePhoto(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updatePhotoWithResponseAsync(String userId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePhoto(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updatePhotoAsync(String userId, MicrosoftGraphProfilePhotoInner body) {
        return this.updatePhotoWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updatePhoto(String userId, MicrosoftGraphProfilePhotoInner body) {
        this.updatePhotoAsync(userId, body).block();
    }

    @Override
    public Response<Void> updatePhotoWithResponse(String userId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.updatePhotoWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deletePhotoWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePhoto(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deletePhotoWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePhoto(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deletePhotoAsync(String userId, String ifMatch) {
        return this.deletePhotoWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deletePhotoAsync(String userId) {
        String ifMatch = null;
        return this.deletePhotoWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deletePhoto(String userId) {
        String ifMatch = null;
        this.deletePhotoAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deletePhotoWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deletePhotoWithResponseAsync(userId, ifMatch, context).block();
    }

    @Override
    public Mono<StreamResponse> getPhotoContentWithResponseAsync(String userId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.getPhotoContent(this.client.getEndpoint(), userId, "application/octet-stream, application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<StreamResponse> getPhotoContentWithResponseAsync(String userId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return this.service.getPhotoContent(this.client.getEndpoint(), userId, "application/octet-stream, application/json", context);
    }

    @Override
    public Flux<ByteBuffer> getPhotoContentAsync(String userId) {
        return this.getPhotoContentWithResponseAsync(userId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    public InputStream getPhotoContent(String userId) {
        final Iterator iterator = this.getPhotoContentAsync(userId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    public StreamResponse getPhotoContentWithResponse(String userId, Context context) {
        return (StreamResponse)this.getPhotoContentWithResponseAsync(userId, context).block();
    }

    @Override
    public Mono<Response<Void>> setPhotoContentWithResponseAsync(String userId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setPhotoContent(this.client.getEndpoint(), userId, data, contentLength, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> setPhotoContentWithResponseAsync(String userId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setPhotoContent(this.client.getEndpoint(), userId, data, contentLength, "application/json", context);
    }

    @Override
    public Mono<Void> setPhotoContentAsync(String userId, Flux<ByteBuffer> data, long contentLength) {
        return this.setPhotoContentWithResponseAsync(userId, data, contentLength).flatMap(res -> Mono.empty());
    }

    @Override
    public void setPhotoContent(String userId, Flux<ByteBuffer> data, long contentLength) {
        this.setPhotoContentAsync(userId, data, contentLength).block();
    }

    @Override
    public Response<Void> setPhotoContentWithResponse(String userId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return (Response)this.setPhotoContentWithResponseAsync(userId, data, contentLength, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listPhotos(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listPhotos(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphProfilePhotoInner> listPhotosAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listPhotosSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listPhotosNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listPhotosAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphProfilePhotoInner> listPhotos(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listPhotosAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(String userId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createPhotos(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotosWithResponseAsync(String userId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createPhotos(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphProfilePhotoInner> createPhotosAsync(String userId, MicrosoftGraphProfilePhotoInner body) {
        return this.createPhotosWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphProfilePhotoInner createPhotos(String userId, MicrosoftGraphProfilePhotoInner body) {
        return (MicrosoftGraphProfilePhotoInner)this.createPhotosAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphProfilePhotoInner> createPhotosWithResponse(String userId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.createPhotosWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(String userId, String profilePhotoId, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getPhotos(this.client.getEndpoint(), userId, profilePhotoId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotosWithResponseAsync(String userId, String profilePhotoId, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getPhotos(this.client.getEndpoint(), userId, profilePhotoId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(String userId, String profilePhotoId, List<UsersSelect> select, List<String> expand) {
        return this.getPhotosWithResponseAsync(userId, profilePhotoId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphProfilePhotoInner> getPhotosAsync(String userId, String profilePhotoId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return this.getPhotosWithResponseAsync(userId, profilePhotoId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphProfilePhotoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphProfilePhotoInner getPhotos(String userId, String profilePhotoId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphProfilePhotoInner)this.getPhotosAsync(userId, profilePhotoId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphProfilePhotoInner> getPhotosWithResponse(String userId, String profilePhotoId, List<UsersSelect> select, List<String> expand, Context context) {
        return (Response)this.getPhotosWithResponseAsync(userId, profilePhotoId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updatePhotosWithResponseAsync(String userId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updatePhotos(this.client.getEndpoint(), userId, profilePhotoId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updatePhotosWithResponseAsync(String userId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updatePhotos(this.client.getEndpoint(), userId, profilePhotoId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updatePhotosAsync(String userId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        return this.updatePhotosWithResponseAsync(userId, profilePhotoId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updatePhotos(String userId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body) {
        this.updatePhotosAsync(userId, profilePhotoId, body).block();
    }

    @Override
    public Response<Void> updatePhotosWithResponse(String userId, String profilePhotoId, MicrosoftGraphProfilePhotoInner body, Context context) {
        return (Response)this.updatePhotosWithResponseAsync(userId, profilePhotoId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deletePhotosWithResponseAsync(String userId, String profilePhotoId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deletePhotos(this.client.getEndpoint(), userId, profilePhotoId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deletePhotosWithResponseAsync(String userId, String profilePhotoId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deletePhotos(this.client.getEndpoint(), userId, profilePhotoId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deletePhotosAsync(String userId, String profilePhotoId, String ifMatch) {
        return this.deletePhotosWithResponseAsync(userId, profilePhotoId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deletePhotosAsync(String userId, String profilePhotoId) {
        String ifMatch = null;
        return this.deletePhotosWithResponseAsync(userId, profilePhotoId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deletePhotos(String userId, String profilePhotoId) {
        String ifMatch = null;
        this.deletePhotosAsync(userId, profilePhotoId, ifMatch).block();
    }

    @Override
    public Response<Void> deletePhotosWithResponse(String userId, String profilePhotoId, String ifMatch, Context context) {
        return (Response)this.deletePhotosWithResponseAsync(userId, profilePhotoId, ifMatch, context).block();
    }

    @Override
    public Mono<StreamResponse> getPhotosContentWithResponseAsync(String userId, String profilePhotoId) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        return FluxUtil.withContext(context -> this.service.getPhotosContent(this.client.getEndpoint(), userId, profilePhotoId, "application/octet-stream, application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<StreamResponse> getPhotosContentWithResponseAsync(String userId, String profilePhotoId, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        String accept = "application/octet-stream, application/json";
        context = this.client.mergeContext(context);
        return this.service.getPhotosContent(this.client.getEndpoint(), userId, profilePhotoId, "application/octet-stream, application/json", context);
    }

    @Override
    public Flux<ByteBuffer> getPhotosContentAsync(String userId, String profilePhotoId) {
        return this.getPhotosContentWithResponseAsync(userId, profilePhotoId).flatMapMany(StreamResponse::getValue);
    }

    @Override
    public InputStream getPhotosContent(String userId, String profilePhotoId) {
        final Iterator iterator = this.getPhotosContentAsync(userId, profilePhotoId).map(ByteBufferBackedInputStream::new).toStream().iterator();
        Enumeration<InputStream> enumeration = new Enumeration<InputStream>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public InputStream nextElement() {
                return (InputStream)iterator.next();
            }
        };
        return new SequenceInputStream((Enumeration<? extends InputStream>)enumeration);
    }

    @Override
    public StreamResponse getPhotosContentWithResponse(String userId, String profilePhotoId, Context context) {
        return (StreamResponse)this.getPhotosContentWithResponseAsync(userId, profilePhotoId, context).block();
    }

    @Override
    public Mono<Response<Void>> setPhotosContentWithResponseAsync(String userId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.setPhotosContent(this.client.getEndpoint(), userId, profilePhotoId, data, contentLength, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> setPhotosContentWithResponseAsync(String userId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (profilePhotoId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter profilePhotoId is required and cannot be null."));
        }
        if (data == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter data is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.setPhotosContent(this.client.getEndpoint(), userId, profilePhotoId, data, contentLength, "application/json", context);
    }

    @Override
    public Mono<Void> setPhotosContentAsync(String userId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        return this.setPhotosContentWithResponseAsync(userId, profilePhotoId, data, contentLength).flatMap(res -> Mono.empty());
    }

    @Override
    public void setPhotosContent(String userId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength) {
        this.setPhotosContentAsync(userId, profilePhotoId, data, contentLength).block();
    }

    @Override
    public Response<Void> setPhotosContentWithResponse(String userId, String profilePhotoId, Flux<ByteBuffer> data, long contentLength, Context context) {
        return (Response)this.setPhotosContentWithResponseAsync(userId, profilePhotoId, data, contentLength, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRegisteredDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRegisteredDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredDevicesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredDevicesAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listRegisteredDevicesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listRegisteredDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listRegisteredDevicesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredDevices(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listRegisteredDevicesAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listRegisteredDevices(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listRegisteredDevicesAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefRegisteredDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefRegisteredDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefRegisteredDevicesSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredDevices(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefRegisteredDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredDevicesNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefRegisteredDevicesAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefRegisteredDevicesNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefRegisteredDevicesAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefRegisteredDevicesSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefRegisteredDevicesNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefRegisteredDevices(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefRegisteredDevicesAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefRegisteredDevices(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefRegisteredDevicesAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefRegisteredDevicesWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefRegisteredDevices(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefRegisteredDevicesWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefRegisteredDevices(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefRegisteredDevicesAsync(String userId, Map<String, Object> body) {
        return this.createRefRegisteredDevicesWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefRegisteredDevices(String userId, Map<String, Object> body) {
        return (Map)this.createRefRegisteredDevicesAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefRegisteredDevicesWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefRegisteredDevicesWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphUserSettingsInner>> getSettingsWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getSettings(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphUserSettingsInner>> getSettingsWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getSettings(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphUserSettingsInner> getSettingsAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        return this.getSettingsWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphUserSettingsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphUserSettingsInner> getSettingsAsync(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return this.getSettingsWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphUserSettingsInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphUserSettingsInner getSettings(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return (MicrosoftGraphUserSettingsInner)this.getSettingsAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphUserSettingsInner> getSettingsWithResponse(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        return (Response)this.getSettingsWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateSettingsWithResponseAsync(String userId, MicrosoftGraphUserSettingsInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateSettings(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateSettingsWithResponseAsync(String userId, MicrosoftGraphUserSettingsInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateSettings(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateSettingsAsync(String userId, MicrosoftGraphUserSettingsInner body) {
        return this.updateSettingsWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateSettings(String userId, MicrosoftGraphUserSettingsInner body) {
        this.updateSettingsAsync(userId, body).block();
    }

    @Override
    public Response<Void> updateSettingsWithResponse(String userId, MicrosoftGraphUserSettingsInner body, Context context) {
        return (Response)this.updateSettingsWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteSettingsWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteSettings(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteSettingsWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteSettings(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteSettingsAsync(String userId, String ifMatch) {
        return this.deleteSettingsWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteSettingsAsync(String userId) {
        String ifMatch = null;
        return this.deleteSettingsWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteSettings(String userId) {
        String ifMatch = null;
        this.deleteSettingsAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteSettingsWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deleteSettingsWithResponseAsync(userId, ifMatch, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphTodoInner>> getTodoWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getTodo(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphTodoInner>> getTodoWithResponseAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getTodo(this.client.getEndpoint(), userId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphTodoInner> getTodoAsync(String userId, List<UsersSelect> select, List<UsersExpand> expand) {
        return this.getTodoWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphTodoInner> getTodoAsync(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return this.getTodoWithResponseAsync(userId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphTodoInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphTodoInner getTodo(String userId) {
        List<UsersSelect> select = null;
        List<UsersExpand> expand = null;
        return (MicrosoftGraphTodoInner)this.getTodoAsync(userId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphTodoInner> getTodoWithResponse(String userId, List<UsersSelect> select, List<UsersExpand> expand, Context context) {
        return (Response)this.getTodoWithResponseAsync(userId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateTodoWithResponseAsync(String userId, MicrosoftGraphTodoInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateTodo(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateTodoWithResponseAsync(String userId, MicrosoftGraphTodoInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateTodo(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateTodoAsync(String userId, MicrosoftGraphTodoInner body) {
        return this.updateTodoWithResponseAsync(userId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateTodo(String userId, MicrosoftGraphTodoInner body) {
        this.updateTodoAsync(userId, body).block();
    }

    @Override
    public Response<Void> updateTodoWithResponse(String userId, MicrosoftGraphTodoInner body, Context context) {
        return (Response)this.updateTodoWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteTodoWithResponseAsync(String userId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteTodo(this.client.getEndpoint(), userId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteTodoWithResponseAsync(String userId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteTodo(this.client.getEndpoint(), userId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteTodoAsync(String userId, String ifMatch) {
        return this.deleteTodoWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteTodoAsync(String userId) {
        String ifMatch = null;
        return this.deleteTodoWithResponseAsync(userId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteTodo(String userId) {
        String ifMatch = null;
        this.deleteTodoAsync(userId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteTodoWithResponse(String userId, String ifMatch, Context context) {
        return (Response)this.deleteTodoWithResponseAsync(userId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listTransitiveMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphDirectoryObjectInner> listTransitiveMemberOf(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listTransitiveMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<String> listRefTransitiveMemberOfAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<String> listRefTransitiveMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedFlux(() -> this.listRefTransitiveMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, context), nextLink -> this.listRefTransitiveMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<String> listRefTransitiveMemberOf(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(userId, top, skip, search, filter, count, orderby));
    }

    @Override
    public PagedIterable<String> listRefTransitiveMemberOf(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, Context context) {
        return new PagedIterable(this.listRefTransitiveMemberOfAsync(userId, top, skip, search, filter, count, orderby, context));
    }

    @Override
    public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String userId, Map<String, Object> body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Map<String, Object>>> createRefTransitiveMemberOfWithResponseAsync(String userId, Map<String, Object> body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createRefTransitiveMemberOf(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<Map<String, Object>> createRefTransitiveMemberOfAsync(String userId, Map<String, Object> body) {
        return this.createRefTransitiveMemberOfWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((Map)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Map<String, Object> createRefTransitiveMemberOf(String userId, Map<String, Object> body) {
        return (Map)this.createRefTransitiveMemberOfAsync(userId, body).block();
    }

    @Override
    public Response<Map<String, Object>> createRefTransitiveMemberOfWithResponse(String userId, Map<String, Object> body, Context context) {
        return (Response)this.createRefTransitiveMemberOfWithResponseAsync(userId, body, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listScopedRoleMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership1)res.getValue()).value(), ((CollectionOfScopedRoleMembership1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMemberOfSinglePageAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listScopedRoleMemberOf(this.client.getEndpoint(), userId, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership1)res.getValue()).value(), ((CollectionOfScopedRoleMembership1)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand) {
        return new PagedFlux(() -> this.listScopedRoleMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedRoleMemberOfNextSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMemberOfAsync(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listScopedRoleMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listScopedRoleMemberOfNextSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMemberOfAsync(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedFlux(() -> this.listScopedRoleMemberOfSinglePageAsync(userId, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listScopedRoleMemberOfNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMemberOf(String userId) {
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<UsersOrderby> orderby = null;
        List<UsersSelect> select = null;
        List<String> expand = null;
        return new PagedIterable(this.listScopedRoleMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphScopedRoleMembershipInner> listScopedRoleMemberOf(String userId, Integer top, Integer skip, String search, String filter, Boolean count, List<UsersOrderby> orderby, List<UsersSelect> select, List<String> expand, Context context) {
        return new PagedIterable(this.listScopedRoleMemberOfAsync(userId, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMemberOfWithResponseAsync(String userId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createScopedRoleMemberOf(this.client.getEndpoint(), userId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMemberOfWithResponseAsync(String userId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createScopedRoleMemberOf(this.client.getEndpoint(), userId, body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMemberOfAsync(String userId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.createScopedRoleMemberOfWithResponseAsync(userId, body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphScopedRoleMembershipInner createScopedRoleMemberOf(String userId, MicrosoftGraphScopedRoleMembershipInner body) {
        return (MicrosoftGraphScopedRoleMembershipInner)this.createScopedRoleMemberOfAsync(userId, body).block();
    }

    @Override
    public Response<MicrosoftGraphScopedRoleMembershipInner> createScopedRoleMemberOfWithResponse(String userId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.createScopedRoleMemberOfWithResponseAsync(userId, body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, List<UsersSelect> select, List<String> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, List<UsersSelect> select, List<String> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMemberOfAsync(String userId, String scopedRoleMembershipId, List<UsersSelect> select, List<String> expand) {
        return this.getScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMemberOfAsync(String userId, String scopedRoleMembershipId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return this.getScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphScopedRoleMembershipInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphScopedRoleMembershipInner getScopedRoleMemberOf(String userId, String scopedRoleMembershipId) {
        List<UsersSelect> select = null;
        List<String> expand = null;
        return (MicrosoftGraphScopedRoleMembershipInner)this.getScopedRoleMemberOfAsync(userId, scopedRoleMembershipId, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphScopedRoleMembershipInner> getScopedRoleMemberOfWithResponse(String userId, String scopedRoleMembershipId, List<UsersSelect> select, List<String> expand, Context context) {
        return (Response)this.getScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateScopedRoleMemberOfAsync(String userId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        return this.updateScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateScopedRoleMemberOf(String userId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body) {
        this.updateScopedRoleMemberOfAsync(userId, scopedRoleMembershipId, body).block();
    }

    @Override
    public Response<Void> updateScopedRoleMemberOfWithResponse(String userId, String scopedRoleMembershipId, MicrosoftGraphScopedRoleMembershipInner body, Context context) {
        return (Response)this.updateScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteScopedRoleMemberOfWithResponseAsync(String userId, String scopedRoleMembershipId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (userId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter userId is required and cannot be null."));
        }
        if (scopedRoleMembershipId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scopedRoleMembershipId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteScopedRoleMemberOf(this.client.getEndpoint(), userId, scopedRoleMembershipId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteScopedRoleMemberOfAsync(String userId, String scopedRoleMembershipId, String ifMatch) {
        return this.deleteScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteScopedRoleMemberOfAsync(String userId, String scopedRoleMembershipId) {
        String ifMatch = null;
        return this.deleteScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteScopedRoleMemberOf(String userId, String scopedRoleMembershipId) {
        String ifMatch = null;
        this.deleteScopedRoleMemberOfAsync(userId, scopedRoleMembershipId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteScopedRoleMemberOfWithResponse(String userId, String scopedRoleMembershipId, String ifMatch, Context context) {
        return (Response)this.deleteScopedRoleMemberOfWithResponseAsync(userId, scopedRoleMembershipId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment2)res.getValue()).value(), ((CollectionOfAppRoleAssignment2)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphAppRoleAssignmentInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfAppRoleAssignment2)res.getValue()).value(), ((CollectionOfAppRoleAssignment2)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listCreatedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listCreatedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listCreatedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefCreatedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefCreatedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefCreatedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefCreatedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObjectAutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listDirectReportsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listDirectReportsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listDirectReportsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefDirectReportsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefDirectReportsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefDirectReportsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject0AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listExtensionsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphExtensionInner>> listExtensionsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listExtensionsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfExtension)res.getValue()).value(), ((CollectionOfExtension)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphLicenseDetailsInner>> listLicenseDetailsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listLicenseDetailsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLicenseDetails)res.getValue()).value(), ((CollectionOfLicenseDetails)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphLicenseDetailsInner>> listLicenseDetailsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listLicenseDetailsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLicenseDetails)res.getValue()).value(), ((CollectionOfLicenseDetails)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject1AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOauth2PermissionGrantsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphOAuth2PermissionGrantInner>> listOauth2PermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOauth2PermissionGrantsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOauth2PermissionGrantsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOauth2PermissionGrantsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOauth2PermissionGrantsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).value(), ((CollectionOfLinksOfOAuth2PermissionGrant)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedDevicesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnedDevicesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedDevicesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnedDevicesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefOwnedDevicesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOwnedDevicesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOwnedDevicesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedDevicesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject2AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listOwnedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listOwnedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listOwnedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefOwnedObjectsNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefOwnedObjectsNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefOwnedObjectsNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefOwnedObjectsNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject3AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listPhotosNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphProfilePhotoInner>> listPhotosNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listPhotosNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfProfilePhoto)res.getValue()).value(), ((CollectionOfProfilePhoto)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredDevicesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRegisteredDevicesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listRegisteredDevicesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRegisteredDevicesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefRegisteredDevicesNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefRegisteredDevicesNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefRegisteredDevicesNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefRegisteredDevicesNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject4AutoGenerated)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphDirectoryObjectInner>> listTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfDirectoryObject5)res.getValue()).value(), ((CollectionOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listRefTransitiveMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<String>> listRefTransitiveMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listRefTransitiveMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).value(), ((CollectionOfLinksOfDirectoryObject5)res.getValue()).odataNextLink(), null));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMemberOfNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listScopedRoleMemberOfNext(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership1)res.getValue()).value(), ((CollectionOfScopedRoleMembership1)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphScopedRoleMembershipInner>> listScopedRoleMemberOfNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listScopedRoleMemberOfNext(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfScopedRoleMembership1)res.getValue()).value(), ((CollectionOfScopedRoleMembership1)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface UsersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/appRoleAssignments")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment2>> listAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/appRoleAssignments")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> createAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphAppRoleAssignmentInner>> getAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @BodyParam(value="application/json") MicrosoftGraphAppRoleAssignmentInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/appRoleAssignments/{appRoleAssignment-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteAppRoleAssignments(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="appRoleAssignment-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/createdObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObjectAutoGenerated>> listCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/createdObjects/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated>> listRefCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/createdObjects/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefCreatedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/directReports")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0AutoGenerated>> listDirectReports(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/directReports/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated>> listRefDirectReports(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/directReports/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefDirectReports(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/extensions")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension>> listExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/extensions")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> createExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/extensions/{extension-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphExtensionInner>> getExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="extension-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="extension-id") String var3, @BodyParam(value="application/json") MicrosoftGraphExtensionInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/extensions/{extension-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteExtensions(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="extension-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/licenseDetails")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLicenseDetails>> listLicenseDetails(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/licenseDetails")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphLicenseDetailsInner>> createLicenseDetails(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphLicenseDetailsInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/licenseDetails/{licenseDetails-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphLicenseDetailsInner>> getLicenseDetails(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="licenseDetails-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/licenseDetails/{licenseDetails-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateLicenseDetails(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="licenseDetails-id") String var3, @BodyParam(value="application/json") MicrosoftGraphLicenseDetailsInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/licenseDetails/{licenseDetails-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteLicenseDetails(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="licenseDetails-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/manager")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphDirectoryObjectInner>> getManager(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/manager/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<String>> getRefManager(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/users/{user-id}/manager/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setRefManager(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/manager/$ref")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteRefManager(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/memberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1AutoGenerated>> listMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/memberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated>> listRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/memberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/oauth2PermissionGrants")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOAuth2PermissionGrant>> listOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/oauth2PermissionGrants/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfOAuth2PermissionGrant>> listRefOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/oauth2PermissionGrants/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOauth2PermissionGrants(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/outlook")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphOutlookUserInner>> getOutlook(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/outlook")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateOutlook(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphOutlookUserInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/outlook")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteOutlook(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/ownedDevices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2AutoGenerated>> listOwnedDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/ownedDevices/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2AutoGenerated>> listRefOwnedDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/ownedDevices/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOwnedDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/ownedObjects")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3AutoGenerated>> listOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/ownedObjects/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3AutoGenerated>> listRefOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/ownedObjects/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefOwnedObjects(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/photo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhoto(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/photo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updatePhoto(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/photo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deletePhoto(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/photo/$value")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<StreamResponse> getPhotoContent(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/users/{user-id}/photo/$value")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setPhotoContent(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var3, @HeaderParam(value="Content-Length") long var4, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/photos")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfProfilePhoto>> listPhotos(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/photos")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> createPhotos(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphProfilePhotoInner>> getPhotos(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="profilePhoto-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updatePhotos(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="profilePhoto-id") String var3, @BodyParam(value="application/json") MicrosoftGraphProfilePhotoInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/photos/{profilePhoto-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deletePhotos(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="profilePhoto-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<StreamResponse> getPhotosContent(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="profilePhoto-id") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/octet-stream"})
        @Put(value="/users/{user-id}/photos/{profilePhoto-id}/$value")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> setPhotosContent(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="profilePhoto-id") String var3, @BodyParam(value="application/octet-stream") Flux<ByteBuffer> var4, @HeaderParam(value="Content-Length") long var5, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/registeredDevices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4AutoGenerated>> listRegisteredDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/registeredDevices/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4AutoGenerated>> listRefRegisteredDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/registeredDevices/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefRegisteredDevices(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/settings")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphUserSettingsInner>> getSettings(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/settings")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateSettings(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphUserSettingsInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/settings")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteSettings(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/todo")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphTodoInner>> getTodo(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$select") String var3, @QueryParam(value="$expand") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/todo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateTodo(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphTodoInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/todo")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteTodo(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/transitiveMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject5>> listRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/transitiveMemberOf/$ref")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Map<String, Object>>> createRefTransitiveMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") Map<String, Object> var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/scopedRoleMemberOf")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership1>> listScopedRoleMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/users/{user-id}/scopedRoleMemberOf")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> createScopedRoleMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/users/{user-id}/scopedRoleMemberOf/{scopedRoleMembership-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphScopedRoleMembershipInner>> getScopedRoleMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/users/{user-id}/scopedRoleMemberOf/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateScopedRoleMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @BodyParam(value="application/json") MicrosoftGraphScopedRoleMembershipInner var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/users/{user-id}/scopedRoleMemberOf/{scopedRoleMembership-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteScopedRoleMemberOf(@HostParam(value="$host") String var1, @PathParam(value="user-id") String var2, @PathParam(value="scopedRoleMembership-id") String var3, @HeaderParam(value="If-Match") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfAppRoleAssignment2>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObjectAutoGenerated>> listCreatedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObjectAutoGenerated>> listRefCreatedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject0AutoGenerated>> listDirectReportsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject0AutoGenerated>> listRefDirectReportsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfExtension>> listExtensionsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLicenseDetails>> listLicenseDetailsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject1AutoGenerated>> listMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject1AutoGenerated>> listRefMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfOAuth2PermissionGrant>> listOauth2PermissionGrantsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfOAuth2PermissionGrant>> listRefOauth2PermissionGrantsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject2AutoGenerated>> listOwnedDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject2AutoGenerated>> listRefOwnedDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject3AutoGenerated>> listOwnedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject3AutoGenerated>> listRefOwnedObjectsNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfProfilePhoto>> listPhotosNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject4AutoGenerated>> listRegisteredDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject4AutoGenerated>> listRefRegisteredDevicesNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfDirectoryObject5>> listTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfLinksOfDirectoryObject5>> listRefTransitiveMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfScopedRoleMembership1>> listScopedRoleMemberOfNext(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

