/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.CollectionFormat;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.ServicePrincipalsServicePrincipalsClient;
import com.azure.resourcemanager.authorization.fluent.models.CollectionOfServicePrincipal;
import com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphServicePrincipalInner;
import com.azure.resourcemanager.authorization.fluent.models.OdataErrorMainException;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsServicePrincipalExpand;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsServicePrincipalOrderby;
import com.azure.resourcemanager.authorization.fluent.models.ServicePrincipalsServicePrincipalSelect;
import com.azure.resourcemanager.authorization.implementation.MicrosoftGraphClientImpl;
import java.util.List;
import reactor.core.publisher.Mono;

public final class ServicePrincipalsServicePrincipalsClientImpl
implements ServicePrincipalsServicePrincipalsClient {
    private final ClientLogger logger = new ClientLogger(ServicePrincipalsServicePrincipalsClientImpl.class);
    private final ServicePrincipalsServicePrincipalsService service;
    private final MicrosoftGraphClientImpl client;

    ServicePrincipalsServicePrincipalsClientImpl(MicrosoftGraphClientImpl client) {
        this.service = (ServicePrincipalsServicePrincipalsService)RestProxy.create(ServicePrincipalsServicePrincipalsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    private Mono<PagedResponse<MicrosoftGraphServicePrincipalInner>> listServicePrincipalSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsServicePrincipalOrderby> orderby, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.listServicePrincipal(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfServicePrincipal)res.getValue()).value(), ((CollectionOfServicePrincipal)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphServicePrincipalInner>> listServicePrincipalSinglePageAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsServicePrincipalOrderby> orderby, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        String orderbyConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(orderby, CollectionFormat.CSV);
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.listServicePrincipal(this.client.getEndpoint(), consistencyLevel, top, skip, search, filter, count, orderbyConverted, selectConverted, expandConverted, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfServicePrincipal)res.getValue()).value(), ((CollectionOfServicePrincipal)res.getValue()).odataNextLink(), null));
    }

    @Override
    public PagedFlux<MicrosoftGraphServicePrincipalInner> listServicePrincipalAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsServicePrincipalOrderby> orderby, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand) {
        return new PagedFlux(() -> this.listServicePrincipalSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    @Override
    public PagedFlux<MicrosoftGraphServicePrincipalInner> listServicePrincipalAsync() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List orderby = null;
        List select = null;
        List expand = null;
        return new PagedFlux(() -> this.listServicePrincipalSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand), nextLink -> this.listMoreSinglePageAsync((String)nextLink));
    }

    private PagedFlux<MicrosoftGraphServicePrincipalInner> listServicePrincipalAsync(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsServicePrincipalOrderby> orderby, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand, Context context) {
        return new PagedFlux(() -> this.listServicePrincipalSinglePageAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context), nextLink -> this.listMoreSinglePageAsync((String)nextLink, context));
    }

    @Override
    public PagedIterable<MicrosoftGraphServicePrincipalInner> listServicePrincipal() {
        String consistencyLevel = null;
        Integer top = null;
        Integer skip = null;
        String search = null;
        String filter = null;
        Boolean count = null;
        List<ServicePrincipalsServicePrincipalOrderby> orderby = null;
        List<ServicePrincipalsServicePrincipalSelect> select = null;
        List<ServicePrincipalsServicePrincipalExpand> expand = null;
        return new PagedIterable(this.listServicePrincipalAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand));
    }

    @Override
    public PagedIterable<MicrosoftGraphServicePrincipalInner> listServicePrincipal(String consistencyLevel, Integer top, Integer skip, String search, String filter, Boolean count, List<ServicePrincipalsServicePrincipalOrderby> orderby, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand, Context context) {
        return new PagedIterable(this.listServicePrincipalAsync(consistencyLevel, top, skip, search, filter, count, orderby, select, expand, context));
    }

    @Override
    public Mono<Response<MicrosoftGraphServicePrincipalInner>> createServicePrincipalWithResponseAsync(MicrosoftGraphServicePrincipalInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createServicePrincipal(this.client.getEndpoint(), body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphServicePrincipalInner>> createServicePrincipalWithResponseAsync(MicrosoftGraphServicePrincipalInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createServicePrincipal(this.client.getEndpoint(), body, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphServicePrincipalInner> createServicePrincipalAsync(MicrosoftGraphServicePrincipalInner body) {
        return this.createServicePrincipalWithResponseAsync(body).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphServicePrincipalInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphServicePrincipalInner createServicePrincipal(MicrosoftGraphServicePrincipalInner body) {
        return (MicrosoftGraphServicePrincipalInner)this.createServicePrincipalAsync(body).block();
    }

    @Override
    public Response<MicrosoftGraphServicePrincipalInner> createServicePrincipalWithResponse(MicrosoftGraphServicePrincipalInner body, Context context) {
        return (Response)this.createServicePrincipalWithResponseAsync(body, context).block();
    }

    @Override
    public Mono<Response<MicrosoftGraphServicePrincipalInner>> getServicePrincipalWithResponseAsync(String servicePrincipalId, String consistencyLevel, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        return FluxUtil.withContext(context -> this.service.getServicePrincipal(this.client.getEndpoint(), servicePrincipalId, consistencyLevel, selectConverted, expandConverted, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<MicrosoftGraphServicePrincipalInner>> getServicePrincipalWithResponseAsync(String servicePrincipalId, String consistencyLevel, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        String selectConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(select, CollectionFormat.CSV);
        String expandConverted = JacksonAdapter.createDefaultSerializerAdapter().serializeList(expand, CollectionFormat.CSV);
        context = this.client.mergeContext(context);
        return this.service.getServicePrincipal(this.client.getEndpoint(), servicePrincipalId, consistencyLevel, selectConverted, expandConverted, "application/json", context);
    }

    @Override
    public Mono<MicrosoftGraphServicePrincipalInner> getServicePrincipalAsync(String servicePrincipalId, String consistencyLevel, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand) {
        return this.getServicePrincipalWithResponseAsync(servicePrincipalId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphServicePrincipalInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public Mono<MicrosoftGraphServicePrincipalInner> getServicePrincipalAsync(String servicePrincipalId) {
        String consistencyLevel = null;
        List<ServicePrincipalsServicePrincipalSelect> select = null;
        List<ServicePrincipalsServicePrincipalExpand> expand = null;
        return this.getServicePrincipalWithResponseAsync(servicePrincipalId, consistencyLevel, select, expand).flatMap(res -> {
            if (res.getValue() != null) {
                return Mono.just((Object)((MicrosoftGraphServicePrincipalInner)res.getValue()));
            }
            return Mono.empty();
        });
    }

    @Override
    public MicrosoftGraphServicePrincipalInner getServicePrincipal(String servicePrincipalId) {
        String consistencyLevel = null;
        List<ServicePrincipalsServicePrincipalSelect> select = null;
        List<ServicePrincipalsServicePrincipalExpand> expand = null;
        return (MicrosoftGraphServicePrincipalInner)this.getServicePrincipalAsync(servicePrincipalId, consistencyLevel, select, expand).block();
    }

    @Override
    public Response<MicrosoftGraphServicePrincipalInner> getServicePrincipalWithResponse(String servicePrincipalId, String consistencyLevel, List<ServicePrincipalsServicePrincipalSelect> select, List<ServicePrincipalsServicePrincipalExpand> expand, Context context) {
        return (Response)this.getServicePrincipalWithResponseAsync(servicePrincipalId, consistencyLevel, select, expand, context).block();
    }

    @Override
    public Mono<Response<Void>> updateServicePrincipalWithResponseAsync(String servicePrincipalId, MicrosoftGraphServicePrincipalInner body) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.updateServicePrincipal(this.client.getEndpoint(), servicePrincipalId, body, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> updateServicePrincipalWithResponseAsync(String servicePrincipalId, MicrosoftGraphServicePrincipalInner body, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        if (body == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter body is required and cannot be null."));
        }
        body.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.updateServicePrincipal(this.client.getEndpoint(), servicePrincipalId, body, "application/json", context);
    }

    @Override
    public Mono<Void> updateServicePrincipalAsync(String servicePrincipalId, MicrosoftGraphServicePrincipalInner body) {
        return this.updateServicePrincipalWithResponseAsync(servicePrincipalId, body).flatMap(res -> Mono.empty());
    }

    @Override
    public void updateServicePrincipal(String servicePrincipalId, MicrosoftGraphServicePrincipalInner body) {
        this.updateServicePrincipalAsync(servicePrincipalId, body).block();
    }

    @Override
    public Response<Void> updateServicePrincipalWithResponse(String servicePrincipalId, MicrosoftGraphServicePrincipalInner body, Context context) {
        return (Response)this.updateServicePrincipalWithResponseAsync(servicePrincipalId, body, context).block();
    }

    @Override
    public Mono<Response<Void>> deleteServicePrincipalWithResponseAsync(String servicePrincipalId, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.deleteServicePrincipal(this.client.getEndpoint(), servicePrincipalId, ifMatch, "application/json", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> deleteServicePrincipalWithResponseAsync(String servicePrincipalId, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (servicePrincipalId == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter servicePrincipalId is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.deleteServicePrincipal(this.client.getEndpoint(), servicePrincipalId, ifMatch, "application/json", context);
    }

    @Override
    public Mono<Void> deleteServicePrincipalAsync(String servicePrincipalId, String ifMatch) {
        return this.deleteServicePrincipalWithResponseAsync(servicePrincipalId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public Mono<Void> deleteServicePrincipalAsync(String servicePrincipalId) {
        String ifMatch = null;
        return this.deleteServicePrincipalWithResponseAsync(servicePrincipalId, ifMatch).flatMap(res -> Mono.empty());
    }

    @Override
    public void deleteServicePrincipal(String servicePrincipalId) {
        String ifMatch = null;
        this.deleteServicePrincipalAsync(servicePrincipalId, ifMatch).block();
    }

    @Override
    public Response<Void> deleteServicePrincipalWithResponse(String servicePrincipalId, String ifMatch, Context context) {
        return (Response)this.deleteServicePrincipalWithResponseAsync(servicePrincipalId, ifMatch, context).block();
    }

    private Mono<PagedResponse<MicrosoftGraphServicePrincipalInner>> listMoreSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        return FluxUtil.withContext(context -> this.service.listMore(nextLink, (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfServicePrincipal)res.getValue()).value(), ((CollectionOfServicePrincipal)res.getValue()).odataNextLink(), null)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<PagedResponse<MicrosoftGraphServicePrincipalInner>> listMoreSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        context = this.client.mergeContext(context);
        return this.service.listMore(nextLink, context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((CollectionOfServicePrincipal)res.getValue()).value(), ((CollectionOfServicePrincipal)res.getValue()).odataNextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MicrosoftGraphClient")
    private static interface ServicePrincipalsServicePrincipalsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfServicePrincipal>> listServicePrincipal(@HostParam(value="$host") String var1, @HeaderParam(value="ConsistencyLevel") String var2, @QueryParam(value="$top") Integer var3, @QueryParam(value="$skip") Integer var4, @QueryParam(value="$search") String var5, @QueryParam(value="$filter") String var6, @QueryParam(value="$count") Boolean var7, @QueryParam(value="$orderby") String var8, @QueryParam(value="$select") String var9, @QueryParam(value="$expand") String var10, @HeaderParam(value="Accept") String var11, Context var12);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/servicePrincipals")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphServicePrincipalInner>> createServicePrincipal(@HostParam(value="$host") String var1, @BodyParam(value="application/json") MicrosoftGraphServicePrincipalInner var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/servicePrincipals/{servicePrincipal-id}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<MicrosoftGraphServicePrincipalInner>> getServicePrincipal(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @HeaderParam(value="ConsistencyLevel") String var3, @QueryParam(value="$select") String var4, @QueryParam(value="$expand") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/servicePrincipals/{servicePrincipal-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> updateServicePrincipal(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @BodyParam(value="application/json") MicrosoftGraphServicePrincipalInner var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/servicePrincipals/{servicePrincipal-id}")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<Void>> deleteServicePrincipal(@HostParam(value="$host") String var1, @PathParam(value="servicePrincipal-id") String var2, @HeaderParam(value="If-Match") String var3, @HeaderParam(value="Accept") String var4, Context var5);

        @Headers(value={"Accept: application/json", "Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=OdataErrorMainException.class)
        public Mono<Response<CollectionOfServicePrincipal>> listMore(@PathParam(value="nextLink", encoded=true) String var1, Context var2);
    }
}

