/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.fluent.models.RoleAssignmentInner;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryGroup;
import com.azure.resourcemanager.authorization.models.ActiveDirectoryUser;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.models.RoleAssignment;
import com.azure.resourcemanager.authorization.models.RoleAssignmentCreateParameters;
import com.azure.resourcemanager.authorization.models.ServicePrincipal;
import com.azure.resourcemanager.resources.fluentcore.arm.models.Resource;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.CreatableImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.resources.models.ResourceGroup;
import java.time.Duration;
import java.util.Locale;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.retry.Retry;

class RoleAssignmentImpl
extends CreatableImpl<RoleAssignment, RoleAssignmentInner, RoleAssignmentImpl>
implements RoleAssignment,
RoleAssignment.Definition {
    private AuthorizationManager manager;
    private String objectId;
    private String userName;
    private String servicePrincipalName;
    private String roleDefinitionId;
    private String roleName;
    private final ClientLogger logger = new ClientLogger(RoleAssignmentImpl.class);

    RoleAssignmentImpl(String name, RoleAssignmentInner innerObject, AuthorizationManager manager) {
        super(name, (Object)innerObject);
        this.manager = manager;
    }

    public boolean isInCreateMode() {
        return ((RoleAssignmentInner)this.innerModel()).id() == null;
    }

    public Mono<RoleAssignment> createResourceAsync() {
        Mono roleDefinitionIdObservable;
        Mono objectIdObservable;
        if (this.objectId != null) {
            objectIdObservable = Mono.just((Object)this.objectId);
        } else if (this.userName != null) {
            objectIdObservable = this.manager.users().getByNameAsync(this.userName).map(user -> user.id());
        } else if (this.servicePrincipalName != null) {
            objectIdObservable = this.manager.servicePrincipals().getByNameAsync(this.servicePrincipalName).map(sp -> sp.id());
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Please pass a non-null value for either object Id, user, group, or service principal"));
        }
        if (this.roleDefinitionId != null) {
            roleDefinitionIdObservable = Mono.just((Object)this.roleDefinitionId);
        } else if (this.roleName != null) {
            roleDefinitionIdObservable = this.manager().roleDefinitions().getByScopeAndRoleNameAsync(this.scope(), this.roleName).map(roleDefinition -> roleDefinition.id());
        } else {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Please pass a non-null value for either role name or role definition ID"));
        }
        return Mono.zip((Mono)objectIdObservable, (Mono)roleDefinitionIdObservable, (objectId, roleDefinitionId) -> new RoleAssignmentCreateParameters().withPrincipalId((String)objectId).withRoleDefinitionId((String)roleDefinitionId)).flatMap(roleAssignmentPropertiesInner -> this.manager().roleServiceClient().getRoleAssignments().createAsync(this.scope(), this.name(), (RoleAssignmentCreateParameters)roleAssignmentPropertiesInner).retryWhen(Retry.withThrowable(throwableFlux -> throwableFlux.zipWith((Publisher)Flux.range((int)1, (int)30), (throwable, integer) -> {
            if (throwable instanceof ManagementException) {
                ManagementException managementException = (ManagementException)throwable;
                String exceptionMessage = managementException.getMessage().toLowerCase(Locale.ROOT);
                if (exceptionMessage.contains("principalnotfound") || exceptionMessage.contains("does not exist in the directory")) {
                    return integer;
                }
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)throwable));
            }
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)throwable));
        }).flatMap(i -> Mono.delay((Duration)ResourceManagerUtils.InternalRuntimeContext.getDelayDuration((Duration)Duration.ofSeconds(i.intValue()))))))).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<RoleAssignmentInner> getInnerAsync() {
        return this.manager.roleServiceClient().getRoleAssignments().getAsync(this.scope(), this.name());
    }

    @Override
    public String scope() {
        return ((RoleAssignmentInner)this.innerModel()).scope();
    }

    @Override
    public String roleDefinitionId() {
        return ((RoleAssignmentInner)this.innerModel()).roleDefinitionId();
    }

    @Override
    public String principalId() {
        return ((RoleAssignmentInner)this.innerModel()).principalId();
    }

    @Override
    public RoleAssignmentImpl forObjectId(String objectId) {
        this.objectId = objectId;
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(ActiveDirectoryUser user) {
        this.objectId = user.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forUser(String name) {
        this.userName = name;
        return this;
    }

    @Override
    public RoleAssignmentImpl forGroup(ActiveDirectoryGroup activeDirectoryGroup) {
        this.objectId = activeDirectoryGroup.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(ServicePrincipal servicePrincipal) {
        this.objectId = servicePrincipal.id();
        return this;
    }

    @Override
    public RoleAssignmentImpl forServicePrincipal(String servicePrincipalName) {
        this.servicePrincipalName = servicePrincipalName;
        return this;
    }

    @Override
    public RoleAssignmentImpl withBuiltInRole(BuiltInRole role) {
        this.roleName = role.toString();
        return this;
    }

    @Override
    public RoleAssignmentImpl withRoleDefinition(String roleDefinitionId) {
        this.roleDefinitionId = roleDefinitionId;
        return this;
    }

    @Override
    public RoleAssignmentImpl withScope(String scope) {
        ((RoleAssignmentInner)this.innerModel()).withScope(scope);
        return this;
    }

    @Override
    public RoleAssignmentImpl withResourceGroupScope(ResourceGroup resourceGroup) {
        return this.withScope(resourceGroup.id());
    }

    @Override
    public RoleAssignmentImpl withResourceScope(Resource resource) {
        return this.withScope(resource.id());
    }

    @Override
    public RoleAssignmentImpl withSubscriptionScope(String subscriptionId) {
        return this.withScope("subscriptions/" + subscriptionId);
    }

    public String id() {
        return ((RoleAssignmentInner)this.innerModel()).id();
    }

    public AuthorizationManager manager() {
        return this.manager;
    }
}

