/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.GlobalAdministratorsClient;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import reactor.core.publisher.Mono;

public final class GlobalAdministratorsClientImpl
implements GlobalAdministratorsClient {
    private final ClientLogger logger = new ClientLogger(GlobalAdministratorsClientImpl.class);
    private final GlobalAdministratorsService service;
    private final AuthorizationManagementClientImpl client;

    GlobalAdministratorsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (GlobalAdministratorsService)RestProxy.create(GlobalAdministratorsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    public Mono<Response<Void>> elevateAccessWithResponseAsync() {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-07-01";
        return FluxUtil.withContext(context -> this.service.elevateAccess(this.client.getEndpoint(), "2015-07-01", (Context)context)).subscriberContext(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext())));
    }

    private Mono<Response<Void>> elevateAccessWithResponseAsync(Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String apiVersion = "2015-07-01";
        context = this.client.mergeContext(context);
        return this.service.elevateAccess(this.client.getEndpoint(), "2015-07-01", context);
    }

    @Override
    public Mono<Void> elevateAccessAsync() {
        return this.elevateAccessWithResponseAsync().flatMap(res -> Mono.empty());
    }

    @Override
    public void elevateAccess() {
        this.elevateAccessAsync().block();
    }

    @Override
    public Response<Void> elevateAccessWithResponse(Context context) {
        return (Response)this.elevateAccessWithResponseAsync(context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    private static interface GlobalAdministratorsService {
        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/providers/Microsoft.Authorization/elevateAccess")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> elevateAccess(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, Context var3);
    }
}

