/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.queue.models.QueueSignedIdentifier;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueueSignedIdentifierWrapper
implements XmlSerializable<QueueSignedIdentifierWrapper> {
    private final List<QueueSignedIdentifier> signedIdentifiers;

    public QueueSignedIdentifierWrapper(List<QueueSignedIdentifier> signedIdentifiers) {
        this.signedIdentifiers = signedIdentifiers;
    }

    public List<QueueSignedIdentifier> items() {
        return this.signedIdentifiers;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.signedIdentifiers != null) {
            for (QueueSignedIdentifier element : this.signedIdentifiers) {
                xmlWriter.writeXml((XmlSerializable)element, "SignedIdentifier");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static QueueSignedIdentifierWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueueSignedIdentifierWrapper.fromXml(xmlReader, null);
    }

    public static QueueSignedIdentifierWrapper fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "SignedIdentifiers" : rootElementName;
        return (QueueSignedIdentifierWrapper)xmlReader.readObject(rootElementName, reader -> {
            ArrayList<QueueSignedIdentifier> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("SignedIdentifier".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<QueueSignedIdentifier>();
                    }
                    items.add(QueueSignedIdentifier.fromXml(reader));
                    continue;
                }
                reader.nextElement();
            }
            return new QueueSignedIdentifierWrapper(items);
        });
    }
}

