/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.queue.models.SendMessageResult;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class SendMessageResultWrapper
implements XmlSerializable<SendMessageResultWrapper> {
    private final List<SendMessageResult> queueMessagesList;

    public SendMessageResultWrapper(List<SendMessageResult> queueMessagesList) {
        this.queueMessagesList = queueMessagesList;
    }

    public List<SendMessageResult> items() {
        return this.queueMessagesList;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueMessagesList" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        if (this.queueMessagesList != null) {
            for (SendMessageResult element : this.queueMessagesList) {
                xmlWriter.writeXml((XmlSerializable)element, "QueueMessage");
            }
        }
        return xmlWriter.writeEndElement();
    }

    public static SendMessageResultWrapper fromXml(XmlReader xmlReader) throws XMLStreamException {
        return SendMessageResultWrapper.fromXml(xmlReader, null);
    }

    public static SendMessageResultWrapper fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueueMessagesList" : rootElementName;
        return (SendMessageResultWrapper)xmlReader.readObject(rootElementName, reader -> {
            ArrayList<SendMessageResult> items = null;
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("QueueMessage".equals(elementName.getLocalPart())) {
                    if (items == null) {
                        items = new ArrayList<SendMessageResult>();
                    }
                    items.add(SendMessageResult.fromXml(reader));
                    continue;
                }
                reader.nextElement();
            }
            return new SendMessageResultWrapper(items);
        });
    }
}

