/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.models.DimensionValue;
import com.azure.developer.loadtesting.models.MetricValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class TimeSeriesElement
implements JsonSerializable<TimeSeriesElement> {
    private List<MetricValue> data;
    private List<DimensionValue> dimensionValues;

    private TimeSeriesElement() {
    }

    public List<MetricValue> getData() {
        return this.data;
    }

    public List<DimensionValue> getDimensionValues() {
        return this.dimensionValues;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("data", this.data, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("dimensionValues", this.dimensionValues, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static TimeSeriesElement fromJson(JsonReader jsonReader) throws IOException {
        return (TimeSeriesElement)jsonReader.readObject(reader -> {
            TimeSeriesElement deserializedTimeSeriesElement = new TimeSeriesElement();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("data".equals(fieldName)) {
                    List data;
                    deserializedTimeSeriesElement.data = data = reader.readArray(reader1 -> MetricValue.fromJson(reader1));
                    continue;
                }
                if ("dimensionValues".equals(fieldName)) {
                    List dimensionValues;
                    deserializedTimeSeriesElement.dimensionValues = dimensionValues = reader.readArray(reader1 -> DimensionValue.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTimeSeriesElement;
        });
    }
}

