/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.Duration;
import java.util.HashSet;
import java.util.Set;

public final class OptionalLoadTestConfiguration
implements JsonSerializable<OptionalLoadTestConfiguration> {
    private String endpointUrl;
    private Integer requestsPerSecond;
    private Integer maxResponseTimeInMs;
    private Integer virtualUsers;
    private Integer rampUpTime;
    private Long duration;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public String getEndpointUrl() {
        return this.endpointUrl;
    }

    public OptionalLoadTestConfiguration setEndpointUrl(String endpointUrl) {
        this.endpointUrl = endpointUrl;
        this.updatedProperties.add("endpointUrl");
        return this;
    }

    public Integer getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public OptionalLoadTestConfiguration setRequestsPerSecond(Integer requestsPerSecond) {
        this.requestsPerSecond = requestsPerSecond;
        this.updatedProperties.add("requestsPerSecond");
        return this;
    }

    public Integer getMaxResponseTimeInMs() {
        return this.maxResponseTimeInMs;
    }

    public OptionalLoadTestConfiguration setMaxResponseTimeInMs(Integer maxResponseTimeInMs) {
        this.maxResponseTimeInMs = maxResponseTimeInMs;
        this.updatedProperties.add("maxResponseTimeInMs");
        return this;
    }

    public Integer getVirtualUsers() {
        return this.virtualUsers;
    }

    public OptionalLoadTestConfiguration setVirtualUsers(Integer virtualUsers) {
        this.virtualUsers = virtualUsers;
        this.updatedProperties.add("virtualUsers");
        return this;
    }

    public Integer getRampUpTime() {
        return this.rampUpTime;
    }

    public OptionalLoadTestConfiguration setRampUpTime(Integer rampUpTime) {
        this.rampUpTime = rampUpTime;
        this.updatedProperties.add("rampUpTime");
        return this;
    }

    public Duration getDuration() {
        if (this.duration == null) {
            return null;
        }
        return Duration.ofSeconds(this.duration);
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
        jsonWriter.writeNumberField("requestsPerSecond", (Number)this.requestsPerSecond);
        jsonWriter.writeNumberField("maxResponseTimeInMs", (Number)this.maxResponseTimeInMs);
        jsonWriter.writeNumberField("virtualUsers", (Number)this.virtualUsers);
        jsonWriter.writeNumberField("rampUpTime", (Number)this.rampUpTime);
        jsonWriter.writeNumberField("duration", (Number)this.duration);
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("endpointUrl")) {
            if (this.endpointUrl == null) {
                jsonWriter.writeNullField("endpointUrl");
            } else {
                jsonWriter.writeStringField("endpointUrl", this.endpointUrl);
            }
        }
        if (this.updatedProperties.contains("requestsPerSecond")) {
            if (this.requestsPerSecond == null) {
                jsonWriter.writeNullField("requestsPerSecond");
            } else {
                jsonWriter.writeNumberField("requestsPerSecond", (Number)this.requestsPerSecond);
            }
        }
        if (this.updatedProperties.contains("maxResponseTimeInMs")) {
            if (this.maxResponseTimeInMs == null) {
                jsonWriter.writeNullField("maxResponseTimeInMs");
            } else {
                jsonWriter.writeNumberField("maxResponseTimeInMs", (Number)this.maxResponseTimeInMs);
            }
        }
        if (this.updatedProperties.contains("virtualUsers")) {
            if (this.virtualUsers == null) {
                jsonWriter.writeNullField("virtualUsers");
            } else {
                jsonWriter.writeNumberField("virtualUsers", (Number)this.virtualUsers);
            }
        }
        if (this.updatedProperties.contains("rampUpTime")) {
            if (this.rampUpTime == null) {
                jsonWriter.writeNullField("rampUpTime");
            } else {
                jsonWriter.writeNumberField("rampUpTime", (Number)this.rampUpTime);
            }
        }
        if (this.updatedProperties.contains("duration")) {
            if (this.duration == null) {
                jsonWriter.writeNullField("duration");
            } else {
                jsonWriter.writeNumberField("duration", (Number)this.duration);
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OptionalLoadTestConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (OptionalLoadTestConfiguration)jsonReader.readObject(reader -> {
            OptionalLoadTestConfiguration deserializedOptionalLoadTestConfiguration = new OptionalLoadTestConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpointUrl".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.endpointUrl = reader.getString();
                    continue;
                }
                if ("requestsPerSecond".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.requestsPerSecond = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("maxResponseTimeInMs".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.maxResponseTimeInMs = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("virtualUsers".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.virtualUsers = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("rampUpTime".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.rampUpTime = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("duration".equals(fieldName)) {
                    deserializedOptionalLoadTestConfiguration.duration = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOptionalLoadTestConfiguration;
        });
    }

    public OptionalLoadTestConfiguration setDuration(Duration duration) {
        this.duration = duration == null ? null : Long.valueOf(duration.getSeconds());
        this.updatedProperties.add("duration");
        return this;
    }

    static {
        JsonMergePatchHelper.setOptionalLoadTestConfigurationAccessor(new JsonMergePatchHelper.OptionalLoadTestConfigurationAccessor(){

            @Override
            public OptionalLoadTestConfiguration prepareModelForJsonMergePatch(OptionalLoadTestConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(OptionalLoadTestConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

