/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting.models;

import com.azure.developer.loadtesting.implementation.JsonMergePatchHelper;
import com.azure.developer.loadtesting.models.OptionalLoadTestConfiguration;
import com.azure.developer.loadtesting.models.RegionalConfiguration;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class LoadTestConfiguration
implements JsonSerializable<LoadTestConfiguration> {
    private Integer engineInstances;
    private Boolean quickStartTest;
    private final Set<String> updatedProperties = new HashSet<String>();
    private boolean jsonMergePatch;
    private Boolean splitAllCsvs;
    private OptionalLoadTestConfiguration optionalLoadTestConfiguration;
    private List<RegionalConfiguration> regionalLoadTestConfiguration;

    private void serializeAsJsonMergePatch(boolean jsonMergePatch) {
        this.jsonMergePatch = jsonMergePatch;
    }

    public Integer getEngineInstances() {
        return this.engineInstances;
    }

    public LoadTestConfiguration setEngineInstances(Integer engineInstances) {
        this.engineInstances = engineInstances;
        this.updatedProperties.add("engineInstances");
        return this;
    }

    public Boolean isQuickStartTest() {
        return this.quickStartTest;
    }

    public LoadTestConfiguration setQuickStartTest(Boolean quickStartTest) {
        this.quickStartTest = quickStartTest;
        this.updatedProperties.add("quickStartTest");
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        if (this.jsonMergePatch) {
            return this.toJsonMergePatch(jsonWriter);
        }
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("engineInstances", (Number)this.engineInstances);
        jsonWriter.writeBooleanField("splitAllCSVs", this.splitAllCsvs);
        jsonWriter.writeBooleanField("quickStartTest", this.quickStartTest);
        jsonWriter.writeJsonField("optionalLoadTestConfig", (JsonSerializable)this.optionalLoadTestConfiguration);
        jsonWriter.writeArrayField("regionalLoadTestConfig", this.regionalLoadTestConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    private JsonWriter toJsonMergePatch(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.updatedProperties.contains("engineInstances")) {
            if (this.engineInstances == null) {
                jsonWriter.writeNullField("engineInstances");
            } else {
                jsonWriter.writeNumberField("engineInstances", (Number)this.engineInstances);
            }
        }
        if (this.updatedProperties.contains("splitAllCsvs")) {
            if (this.splitAllCsvs == null) {
                jsonWriter.writeNullField("splitAllCSVs");
            } else {
                jsonWriter.writeBooleanField("splitAllCSVs", this.splitAllCsvs);
            }
        }
        if (this.updatedProperties.contains("quickStartTest")) {
            if (this.quickStartTest == null) {
                jsonWriter.writeNullField("quickStartTest");
            } else {
                jsonWriter.writeBooleanField("quickStartTest", this.quickStartTest);
            }
        }
        if (this.updatedProperties.contains("optionalLoadTestConfiguration")) {
            if (this.optionalLoadTestConfiguration == null) {
                jsonWriter.writeNullField("optionalLoadTestConfig");
            } else {
                JsonMergePatchHelper.getOptionalLoadTestConfigurationAccessor().prepareModelForJsonMergePatch(this.optionalLoadTestConfiguration, true);
                jsonWriter.writeJsonField("optionalLoadTestConfig", (JsonSerializable)this.optionalLoadTestConfiguration);
                JsonMergePatchHelper.getOptionalLoadTestConfigurationAccessor().prepareModelForJsonMergePatch(this.optionalLoadTestConfiguration, false);
            }
        }
        if (this.updatedProperties.contains("regionalLoadTestConfiguration")) {
            if (this.regionalLoadTestConfiguration == null) {
                jsonWriter.writeNullField("regionalLoadTestConfig");
            } else {
                jsonWriter.writeArrayField("regionalLoadTestConfig", this.regionalLoadTestConfiguration, (writer, element) -> writer.writeJson((JsonSerializable)element));
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LoadTestConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return (LoadTestConfiguration)jsonReader.readObject(reader -> {
            LoadTestConfiguration deserializedLoadTestConfiguration = new LoadTestConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("engineInstances".equals(fieldName)) {
                    deserializedLoadTestConfiguration.engineInstances = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("splitAllCSVs".equals(fieldName)) {
                    deserializedLoadTestConfiguration.splitAllCsvs = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("quickStartTest".equals(fieldName)) {
                    deserializedLoadTestConfiguration.quickStartTest = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("optionalLoadTestConfig".equals(fieldName)) {
                    deserializedLoadTestConfiguration.optionalLoadTestConfiguration = OptionalLoadTestConfiguration.fromJson(reader);
                    continue;
                }
                if ("regionalLoadTestConfig".equals(fieldName)) {
                    List regionalLoadTestConfiguration;
                    deserializedLoadTestConfiguration.regionalLoadTestConfiguration = regionalLoadTestConfiguration = reader.readArray(reader1 -> RegionalConfiguration.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLoadTestConfiguration;
        });
    }

    public Boolean isSplitAllCsvs() {
        return this.splitAllCsvs;
    }

    public LoadTestConfiguration setSplitAllCsvs(Boolean splitAllCsvs) {
        this.splitAllCsvs = splitAllCsvs;
        this.updatedProperties.add("splitAllCsvs");
        return this;
    }

    public OptionalLoadTestConfiguration getOptionalLoadTestConfiguration() {
        return this.optionalLoadTestConfiguration;
    }

    public LoadTestConfiguration setOptionalLoadTestConfiguration(OptionalLoadTestConfiguration optionalLoadTestConfiguration) {
        this.optionalLoadTestConfiguration = optionalLoadTestConfiguration;
        this.updatedProperties.add("optionalLoadTestConfiguration");
        return this;
    }

    public List<RegionalConfiguration> getRegionalLoadTestConfiguration() {
        return this.regionalLoadTestConfiguration;
    }

    public LoadTestConfiguration setRegionalLoadTestConfiguration(List<RegionalConfiguration> regionalLoadTestConfiguration) {
        this.regionalLoadTestConfiguration = regionalLoadTestConfiguration;
        this.updatedProperties.add("regionalLoadTestConfiguration");
        return this;
    }

    static {
        JsonMergePatchHelper.setLoadTestConfigurationAccessor(new JsonMergePatchHelper.LoadTestConfigurationAccessor(){

            @Override
            public LoadTestConfiguration prepareModelForJsonMergePatch(LoadTestConfiguration model, boolean jsonMergePatchEnabled) {
                model.serializeAsJsonMergePatch(jsonMergePatchEnabled);
                return model;
            }

            @Override
            public boolean isJsonMergePatch(LoadTestConfiguration model) {
                return model.jsonMergePatch;
            }
        });
    }
}

