/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.loadtesting;

import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.developer.loadtesting.models.FileValidationStatus;
import com.azure.developer.loadtesting.models.LoadTestRun;
import com.azure.developer.loadtesting.models.TestFileInfo;
import com.azure.developer.loadtesting.models.TestProfileRun;
import com.azure.developer.loadtesting.models.TestProfileRunStatus;
import com.azure.developer.loadtesting.models.TestRunStatus;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Callable;
import reactor.core.publisher.Mono;

final class PollingUtils {
    PollingUtils() {
    }

    static <T> Mono<PollResponse<T>> getPollResponseMono(Callable<PollResponse<T>> pollOperation) {
        try {
            return Mono.just(pollOperation.call());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }

    static PollResponse<BinaryData> getValidationStatus(BinaryData fileBinary) throws RuntimeException {
        LongRunningOperationStatus lroStatus;
        String validationStatus;
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])fileBinary.toBytes());){
            Map jsonTree = jsonReader.readMap(JsonReader::readUntyped);
            validationStatus = jsonTree.get("validationStatus").toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered exception while retrieving validation status", e);
        }
        switch (validationStatus) {
            case "VALIDATION_NOT_REQUIRED": 
            case "VALIDATION_SUCCESS": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "VALIDATION_FAILURE": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "VALIDATION_INITIATED": {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            case "NOT_VALIDATED": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
            }
        }
        return new PollResponse(lroStatus, (Object)fileBinary);
    }

    static PollResponse<TestFileInfo> getValidationStatus(TestFileInfo testFile) throws RuntimeException {
        LongRunningOperationStatus lroStatus = FileValidationStatus.VALIDATION_NOT_REQUIRED.equals((Object)testFile.getValidationStatus()) || FileValidationStatus.VALIDATION_SUCCESS.equals((Object)testFile.getValidationStatus()) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (FileValidationStatus.VALIDATION_FAILURE.equals((Object)testFile.getValidationStatus()) ? LongRunningOperationStatus.FAILED : (FileValidationStatus.VALIDATION_INITIATED.equals((Object)testFile.getValidationStatus()) ? LongRunningOperationStatus.IN_PROGRESS : (FileValidationStatus.NOT_VALIDATED.equals((Object)testFile.getValidationStatus()) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : LongRunningOperationStatus.NOT_STARTED)));
        return new PollResponse(lroStatus, (Object)testFile);
    }

    static PollResponse<BinaryData> getTestRunStatus(BinaryData testRunBinary) throws RuntimeException {
        LongRunningOperationStatus lroStatus;
        String status;
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])testRunBinary.toBytes());){
            Map jsonTree = jsonReader.readMap(JsonReader::readUntyped);
            status = jsonTree.get("status").toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered exception while retrieving test run status", e);
        }
        switch (status) {
            case "NOTSTARTED": {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
                break;
            }
            case "DONE": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "FAILED": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "CANCELLED": {
                lroStatus = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
            }
        }
        return new PollResponse(lroStatus, (Object)testRunBinary);
    }

    static PollResponse<LoadTestRun> getTestRunStatus(LoadTestRun loadTestRun) throws RuntimeException {
        LongRunningOperationStatus lroStatus = TestRunStatus.NOT_STARTED.equals((Object)loadTestRun.getStatus()) ? LongRunningOperationStatus.NOT_STARTED : (TestRunStatus.DONE.equals((Object)loadTestRun.getStatus()) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (TestRunStatus.FAILED.equals((Object)loadTestRun.getStatus()) ? LongRunningOperationStatus.FAILED : (TestRunStatus.CANCELLED.equals((Object)loadTestRun.getStatus()) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.IN_PROGRESS)));
        return new PollResponse(lroStatus, (Object)loadTestRun);
    }

    static PollResponse<BinaryData> getTestProfileRunStatus(BinaryData testProfileRunBinary) throws RuntimeException {
        LongRunningOperationStatus lroStatus;
        String status;
        try (JsonReader jsonReader = JsonProviders.createReader((byte[])testProfileRunBinary.toBytes());){
            Map jsonTree = jsonReader.readMap(JsonReader::readUntyped);
            status = jsonTree.get("status").toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Encountered exception while retrieving test profile run status", e);
        }
        switch (status) {
            case "NOTSTARTED": {
                lroStatus = LongRunningOperationStatus.NOT_STARTED;
                break;
            }
            case "DONE": {
                lroStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case "FAILED": {
                lroStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case "CANCELLED": {
                lroStatus = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            default: {
                lroStatus = LongRunningOperationStatus.IN_PROGRESS;
            }
        }
        return new PollResponse(lroStatus, (Object)testProfileRunBinary);
    }

    static PollResponse<TestProfileRun> getTestProfileRunStatus(TestProfileRun testProfileRun) throws RuntimeException {
        LongRunningOperationStatus lroStatus = TestProfileRunStatus.NOT_STARTED.equals((Object)testProfileRun.getStatus()) ? LongRunningOperationStatus.NOT_STARTED : (TestProfileRunStatus.DONE.equals((Object)testProfileRun.getStatus()) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (TestProfileRunStatus.FAILED.equals((Object)testProfileRun.getStatus()) ? LongRunningOperationStatus.FAILED : (TestProfileRunStatus.CANCELLED.equals((Object)testProfileRun.getStatus()) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.IN_PROGRESS)));
        return new PollResponse(lroStatus, (Object)testProfileRun);
    }
}

