/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter.models;

import com.azure.developer.devcenter.models.SkuName;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DevBoxHardwareProfile
implements JsonSerializable<DevBoxHardwareProfile> {
    private SkuName skuName;
    private Integer vCpus;
    private Integer memoryInGb;

    private DevBoxHardwareProfile() {
    }

    public SkuName getSkuName() {
        return this.skuName;
    }

    public Integer getVCpus() {
        return this.vCpus;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static DevBoxHardwareProfile fromJson(JsonReader jsonReader) throws IOException {
        return (DevBoxHardwareProfile)jsonReader.readObject(reader -> {
            DevBoxHardwareProfile deserializedDevBoxHardwareProfile = new DevBoxHardwareProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("skuName".equals(fieldName)) {
                    deserializedDevBoxHardwareProfile.skuName = SkuName.fromString(reader.getString());
                    continue;
                }
                if ("vCPUs".equals(fieldName)) {
                    deserializedDevBoxHardwareProfile.vCpus = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("memoryGB".equals(fieldName)) {
                    deserializedDevBoxHardwareProfile.memoryInGb = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDevBoxHardwareProfile;
        });
    }

    public Integer getMemoryInGb() {
        return this.memoryInGb;
    }
}

