/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.polling.SyncPoller;
import com.azure.developer.devcenter.DeploymentEnvironmentsClientBuilder;
import com.azure.developer.devcenter.implementation.DeploymentEnvironmentsClientImpl;
import com.azure.developer.devcenter.models.DevCenterCatalog;
import com.azure.developer.devcenter.models.DevCenterEnvironment;
import com.azure.developer.devcenter.models.DevCenterEnvironmentType;
import com.azure.developer.devcenter.models.DevCenterOperationDetails;
import com.azure.developer.devcenter.models.EnvironmentDefinition;

@ServiceClient(builder=DeploymentEnvironmentsClientBuilder.class)
public final class DeploymentEnvironmentsClient {
    private final DeploymentEnvironmentsClientImpl serviceClient;

    DeploymentEnvironmentsClient(DeploymentEnvironmentsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listAllEnvironments(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listAllEnvironments(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listEnvironments(String projectName, String userId, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironments(projectName, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnvironmentWithResponse(String projectName, String userId, String environmentName, RequestOptions requestOptions) {
        return this.serviceClient.getEnvironmentWithResponse(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, BinaryData> beginCreateOrUpdateEnvironment(String projectName, String userId, String environmentName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.beginCreateOrUpdateEnvironment(projectName, userId, environmentName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<BinaryData, Void> beginDeleteEnvironment(String projectName, String userId, String environmentName, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteEnvironment(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listCatalogs(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listCatalogs(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getCatalogWithResponse(String projectName, String catalogName, RequestOptions requestOptions) {
        return this.serviceClient.getCatalogWithResponse(projectName, catalogName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listEnvironmentDefinitions(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentDefinitions(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listEnvironmentDefinitionsByCatalog(String projectName, String catalogName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentDefinitionsByCatalog(projectName, catalogName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<BinaryData> getEnvironmentDefinitionWithResponse(String projectName, String catalogName, String definitionName, RequestOptions requestOptions) {
        return this.serviceClient.getEnvironmentDefinitionWithResponse(projectName, catalogName, definitionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<BinaryData> listEnvironmentTypes(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentTypes(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevCenterEnvironment> listAllEnvironments(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listAllEnvironments(projectName, requestOptions).mapPage(bodyItemValue -> (DevCenterEnvironment)bodyItemValue.toObject(DevCenterEnvironment.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevCenterEnvironment> listEnvironments(String projectName, String userId) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listEnvironments(projectName, userId, requestOptions).mapPage(bodyItemValue -> (DevCenterEnvironment)bodyItemValue.toObject(DevCenterEnvironment.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevCenterEnvironment getEnvironment(String projectName, String userId, String environmentName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevCenterEnvironment)((BinaryData)this.getEnvironmentWithResponse(projectName, userId, environmentName, requestOptions).getValue()).toObject(DevCenterEnvironment.class);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, DevCenterEnvironment> beginCreateOrUpdateEnvironment(String projectName, String userId, DevCenterEnvironment environment) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCreateOrUpdateEnvironmentWithModel(projectName, userId, environment.getName(), BinaryData.fromObject((Object)environment), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<DevCenterOperationDetails, Void> beginDeleteEnvironment(String projectName, String userId, String environmentName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginDeleteEnvironmentWithModel(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevCenterCatalog> listCatalogs(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listCatalogs(projectName, requestOptions).mapPage(bodyItemValue -> (DevCenterCatalog)bodyItemValue.toObject(DevCenterCatalog.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public DevCenterCatalog getCatalog(String projectName, String catalogName) {
        RequestOptions requestOptions = new RequestOptions();
        return (DevCenterCatalog)((BinaryData)this.getCatalogWithResponse(projectName, catalogName, requestOptions).getValue()).toObject(DevCenterCatalog.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnvironmentDefinition> listEnvironmentDefinitions(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listEnvironmentDefinitions(projectName, requestOptions).mapPage(bodyItemValue -> (EnvironmentDefinition)bodyItemValue.toObject(EnvironmentDefinition.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<EnvironmentDefinition> listEnvironmentDefinitionsByCatalog(String projectName, String catalogName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listEnvironmentDefinitionsByCatalog(projectName, catalogName, requestOptions).mapPage(bodyItemValue -> (EnvironmentDefinition)bodyItemValue.toObject(EnvironmentDefinition.class));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EnvironmentDefinition getEnvironmentDefinition(String projectName, String catalogName, String definitionName) {
        RequestOptions requestOptions = new RequestOptions();
        return (EnvironmentDefinition)((BinaryData)this.getEnvironmentDefinitionWithResponse(projectName, catalogName, definitionName, requestOptions).getValue()).toObject(EnvironmentDefinition.class);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<DevCenterEnvironmentType> listEnvironmentTypes(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.listEnvironmentTypes(projectName, requestOptions).mapPage(bodyItemValue -> (DevCenterEnvironmentType)bodyItemValue.toObject(DevCenterEnvironmentType.class));
    }
}

