/*
 * Decompiled with CFR 0.152.
 */
package com.azure.developer.devcenter;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Response;
import com.azure.core.util.BinaryData;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.developer.devcenter.DeploymentEnvironmentsClientBuilder;
import com.azure.developer.devcenter.implementation.DeploymentEnvironmentsClientImpl;
import com.azure.developer.devcenter.models.DevCenterCatalog;
import com.azure.developer.devcenter.models.DevCenterEnvironment;
import com.azure.developer.devcenter.models.DevCenterEnvironmentType;
import com.azure.developer.devcenter.models.DevCenterOperationDetails;
import com.azure.developer.devcenter.models.EnvironmentDefinition;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=DeploymentEnvironmentsClientBuilder.class, isAsync=true)
public final class DeploymentEnvironmentsAsyncClient {
    private final DeploymentEnvironmentsClientImpl serviceClient;

    DeploymentEnvironmentsAsyncClient(DeploymentEnvironmentsClientImpl serviceClient) {
        this.serviceClient = serviceClient;
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listAllEnvironments(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listAllEnvironmentsAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listEnvironments(String projectName, String userId, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentsAsync(projectName, userId, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnvironmentWithResponse(String projectName, String userId, String environmentName, RequestOptions requestOptions) {
        return this.serviceClient.getEnvironmentWithResponseAsync(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, BinaryData> beginCreateOrUpdateEnvironment(String projectName, String userId, String environmentName, BinaryData body, RequestOptions requestOptions) {
        return this.serviceClient.beginCreateOrUpdateEnvironmentAsync(projectName, userId, environmentName, body, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<BinaryData, Void> beginDeleteEnvironment(String projectName, String userId, String environmentName, RequestOptions requestOptions) {
        return this.serviceClient.beginDeleteEnvironmentAsync(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listCatalogs(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listCatalogsAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getCatalogWithResponse(String projectName, String catalogName, RequestOptions requestOptions) {
        return this.serviceClient.getCatalogWithResponseAsync(projectName, catalogName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listEnvironmentDefinitions(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentDefinitionsAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listEnvironmentDefinitionsByCatalog(String projectName, String catalogName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentDefinitionsByCatalogAsync(projectName, catalogName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<BinaryData>> getEnvironmentDefinitionWithResponse(String projectName, String catalogName, String definitionName, RequestOptions requestOptions) {
        return this.serviceClient.getEnvironmentDefinitionWithResponseAsync(projectName, catalogName, definitionName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<BinaryData> listEnvironmentTypes(String projectName, RequestOptions requestOptions) {
        return this.serviceClient.listEnvironmentTypesAsync(projectName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevCenterEnvironment> listAllEnvironments(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listAllEnvironments(projectName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevCenterEnvironment)protocolMethodData.toObject(DevCenterEnvironment.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevCenterEnvironment> listEnvironments(String projectName, String userId) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listEnvironments(projectName, userId, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevCenterEnvironment)protocolMethodData.toObject(DevCenterEnvironment.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevCenterEnvironment> getEnvironment(String projectName, String userId, String environmentName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEnvironmentWithResponse(projectName, userId, environmentName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevCenterEnvironment)protocolMethodData.toObject(DevCenterEnvironment.class));
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, DevCenterEnvironment> beginCreateOrUpdateEnvironment(String projectName, String userId, DevCenterEnvironment environment) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginCreateOrUpdateEnvironmentWithModelAsync(projectName, userId, environment.getName(), BinaryData.fromObject((Object)environment), requestOptions);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<DevCenterOperationDetails, Void> beginDeleteEnvironment(String projectName, String userId, String environmentName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.serviceClient.beginDeleteEnvironmentWithModelAsync(projectName, userId, environmentName, requestOptions);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevCenterCatalog> listCatalogs(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listCatalogs(projectName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevCenterCatalog)protocolMethodData.toObject(DevCenterCatalog.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<DevCenterCatalog> getCatalog(String projectName, String catalogName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getCatalogWithResponse(projectName, catalogName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (DevCenterCatalog)protocolMethodData.toObject(DevCenterCatalog.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnvironmentDefinition> listEnvironmentDefinitions(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listEnvironmentDefinitions(projectName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (EnvironmentDefinition)protocolMethodData.toObject(EnvironmentDefinition.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<EnvironmentDefinition> listEnvironmentDefinitionsByCatalog(String projectName, String catalogName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listEnvironmentDefinitionsByCatalog(projectName, catalogName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (EnvironmentDefinition)protocolMethodData.toObject(EnvironmentDefinition.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<EnvironmentDefinition> getEnvironmentDefinition(String projectName, String catalogName, String definitionName) {
        RequestOptions requestOptions = new RequestOptions();
        return this.getEnvironmentDefinitionWithResponse(projectName, catalogName, definitionName, requestOptions).flatMap(FluxUtil::toMono).map(protocolMethodData -> (EnvironmentDefinition)protocolMethodData.toObject(EnvironmentDefinition.class));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<DevCenterEnvironmentType> listEnvironmentTypes(String projectName) {
        RequestOptions requestOptions = new RequestOptions();
        PagedFlux<BinaryData> pagedFluxResponse = this.listEnvironmentTypes(projectName, requestOptions);
        return PagedFlux.create(() -> (continuationTokenParam, pageSizeParam) -> {
            Flux flux = continuationTokenParam == null ? pagedFluxResponse.byPage().take(1L) : pagedFluxResponse.byPage(continuationTokenParam).take(1L);
            return flux.map(pagedResponse -> new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(protocolMethodData -> (DevCenterEnvironmentType)protocolMethodData.toObject(DevCenterEnvironmentType.class)).collect(Collectors.toList()), (String)pagedResponse.getContinuationToken(), null));
        });
    }
}

