/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentBuildMode;
import com.azure.ai.documentintelligence.models.DocumentFieldSchema;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class DocumentTypeDetails
implements JsonSerializable<DocumentTypeDetails> {
    private String description;
    private DocumentBuildMode buildMode;
    private Map<String, DocumentFieldSchema> fieldSchema;
    private Map<String, Double> fieldConfidence;
    private String modelId;
    private Double confidenceThreshold;
    private List<DocumentAnalysisFeature> features;
    private List<String> queryFields;
    private Integer maxDocumentsToAnalyze;

    public String getDescription() {
        return this.description;
    }

    public DocumentTypeDetails setDescription(String description) {
        this.description = description;
        return this;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public DocumentTypeDetails setBuildMode(DocumentBuildMode buildMode) {
        this.buildMode = buildMode;
        return this;
    }

    public Map<String, DocumentFieldSchema> getFieldSchema() {
        return this.fieldSchema;
    }

    public DocumentTypeDetails setFieldSchema(Map<String, DocumentFieldSchema> fieldSchema) {
        this.fieldSchema = fieldSchema;
        return this;
    }

    public Map<String, Double> getFieldConfidence() {
        return this.fieldConfidence;
    }

    public DocumentTypeDetails setFieldConfidence(Map<String, Double> fieldConfidence) {
        this.fieldConfidence = fieldConfidence;
        return this;
    }

    public String getModelId() {
        return this.modelId;
    }

    public DocumentTypeDetails setModelId(String modelId) {
        this.modelId = modelId;
        return this;
    }

    public Double getConfidenceThreshold() {
        return this.confidenceThreshold;
    }

    public DocumentTypeDetails setConfidenceThreshold(Double confidenceThreshold) {
        this.confidenceThreshold = confidenceThreshold;
        return this;
    }

    public List<DocumentAnalysisFeature> getFeatures() {
        return this.features;
    }

    public DocumentTypeDetails setFeatures(List<DocumentAnalysisFeature> features) {
        this.features = features;
        return this;
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    public DocumentTypeDetails setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    public Integer getMaxDocumentsToAnalyze() {
        return this.maxDocumentsToAnalyze;
    }

    public DocumentTypeDetails setMaxDocumentsToAnalyze(Integer maxDocumentsToAnalyze) {
        this.maxDocumentsToAnalyze = maxDocumentsToAnalyze;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("buildMode", this.buildMode == null ? null : this.buildMode.toString());
        jsonWriter.writeMapField("fieldSchema", this.fieldSchema, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("fieldConfidence", this.fieldConfidence, (writer, element) -> writer.writeDouble(element.doubleValue()));
        jsonWriter.writeStringField("modelId", this.modelId);
        jsonWriter.writeNumberField("confidenceThreshold", (Number)this.confidenceThreshold);
        jsonWriter.writeArrayField("features", this.features, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("queryFields", this.queryFields, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("maxDocumentsToAnalyze", (Number)this.maxDocumentsToAnalyze);
        return jsonWriter.writeEndObject();
    }

    public static DocumentTypeDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentTypeDetails)jsonReader.readObject(reader -> {
            DocumentTypeDetails deserializedDocumentTypeDetails = new DocumentTypeDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedDocumentTypeDetails.description = reader.getString();
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    deserializedDocumentTypeDetails.buildMode = DocumentBuildMode.fromString(reader.getString());
                    continue;
                }
                if ("fieldSchema".equals(fieldName)) {
                    Map fieldSchema;
                    deserializedDocumentTypeDetails.fieldSchema = fieldSchema = reader.readMap(reader1 -> DocumentFieldSchema.fromJson(reader1));
                    continue;
                }
                if ("fieldConfidence".equals(fieldName)) {
                    Map fieldConfidence;
                    deserializedDocumentTypeDetails.fieldConfidence = fieldConfidence = reader.readMap(reader1 -> reader1.getDouble());
                    continue;
                }
                if ("modelId".equals(fieldName)) {
                    deserializedDocumentTypeDetails.modelId = reader.getString();
                    continue;
                }
                if ("confidenceThreshold".equals(fieldName)) {
                    deserializedDocumentTypeDetails.confidenceThreshold = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("features".equals(fieldName)) {
                    List features;
                    deserializedDocumentTypeDetails.features = features = reader.readArray(reader1 -> DocumentAnalysisFeature.fromString(reader1.getString()));
                    continue;
                }
                if ("queryFields".equals(fieldName)) {
                    List queryFields;
                    deserializedDocumentTypeDetails.queryFields = queryFields = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("maxDocumentsToAnalyze".equals(fieldName)) {
                    deserializedDocumentTypeDetails.maxDocumentsToAnalyze = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentTypeDetails;
        });
    }
}

