/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentSpan;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public final class DocumentLine
implements JsonSerializable<DocumentLine> {
    private final String content;
    private List<Double> polygon;
    private final List<DocumentSpan> spans;

    private DocumentLine(String content, List<DocumentSpan> spans) {
        this.content = content;
        this.spans = spans;
    }

    public String getContent() {
        return this.content;
    }

    public List<Double> getPolygon() {
        return this.polygon;
    }

    public List<DocumentSpan> getSpans() {
        return this.spans;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("content", this.content);
        jsonWriter.writeArrayField("spans", this.spans, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("polygon", this.polygon, (writer, element) -> writer.writeDouble(element.doubleValue()));
        return jsonWriter.writeEndObject();
    }

    public static DocumentLine fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentLine)jsonReader.readObject(reader -> {
            String content = null;
            List spans = null;
            List polygon = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("content".equals(fieldName)) {
                    content = reader.getString();
                    continue;
                }
                if ("spans".equals(fieldName)) {
                    spans = reader.readArray(reader1 -> DocumentSpan.fromJson(reader1));
                    continue;
                }
                if ("polygon".equals(fieldName)) {
                    polygon = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                reader.skipChildren();
            }
            DocumentLine deserializedDocumentLine = new DocumentLine(content, spans);
            deserializedDocumentLine.polygon = polygon;
            return deserializedDocumentLine;
        });
    }
}

