/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentClassifierBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentClassifierCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceError;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.azure.ai.documentintelligence.models.DocumentModelBuildOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelComposeOperationDetails;
import com.azure.ai.documentintelligence.models.DocumentModelCopyToOperationDetails;
import com.azure.ai.documentintelligence.models.OperationKind;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;

public class DocumentIntelligenceOperationDetails
implements JsonSerializable<DocumentIntelligenceOperationDetails> {
    private OperationKind kind = OperationKind.fromString("DocumentIntelligenceOperationDetails");
    private String operationId;
    private final DocumentIntelligenceOperationStatus status;
    private Integer percentCompleted;
    private final OffsetDateTime createdOn;
    private final OffsetDateTime lastUpdatedOn;
    private final String resourceLocation;
    private String apiVersion;
    private Map<String, String> tags;
    private DocumentIntelligenceError error;

    protected DocumentIntelligenceOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn, OffsetDateTime lastUpdatedOn, String resourceLocation) {
        this.status = status;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
        this.resourceLocation = resourceLocation;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public String getOperationId() {
        return this.operationId;
    }

    DocumentIntelligenceOperationDetails setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    DocumentIntelligenceOperationDetails setPercentCompleted(Integer percentCompleted) {
        this.percentCompleted = percentCompleted;
        return this;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public String getResourceLocation() {
        return this.resourceLocation;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    DocumentIntelligenceOperationDetails setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    DocumentIntelligenceOperationDetails setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public DocumentIntelligenceError getError() {
        return this.error;
    }

    DocumentIntelligenceOperationDetails setError(DocumentIntelligenceError error) {
        this.error = error;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedOn));
        jsonWriter.writeStringField("resourceLocation", this.resourceLocation);
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static DocumentIntelligenceOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentIntelligenceOperationDetails)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                Object fieldName;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("kind".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("documentModelCompose".equals(discriminatorValue)) {
                    fieldName = DocumentModelComposeOperationDetails.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("documentModelCopyTo".equals(discriminatorValue)) {
                    fieldName = DocumentModelCopyToOperationDetails.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("documentClassifierCopyTo".equals(discriminatorValue)) {
                    fieldName = DocumentClassifierCopyToOperationDetails.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("documentClassifierBuild".equals(discriminatorValue)) {
                    fieldName = DocumentClassifierBuildOperationDetails.fromJson(readerToUse.reset());
                    return fieldName;
                }
                if ("documentModelBuild".equals(discriminatorValue)) {
                    fieldName = DocumentModelBuildOperationDetails.fromJson(readerToUse.reset());
                    return fieldName;
                }
                fieldName = DocumentIntelligenceOperationDetails.fromJsonKnownDiscriminator(readerToUse.reset());
                return fieldName;
            }
        });
    }

    static DocumentIntelligenceOperationDetails fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DocumentIntelligenceOperationDetails)jsonReader.readObject(reader -> {
            String operationId = null;
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resourceLocation = null;
            OperationKind kind = null;
            Integer percentCompleted = null;
            String apiVersion = null;
            Map tags = null;
            DocumentIntelligenceError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("operationId".equals(fieldName)) {
                    operationId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resourceLocation".equals(fieldName)) {
                    resourceLocation = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    kind = OperationKind.fromString(reader.getString());
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DocumentIntelligenceOperationDetails deserializedDocumentIntelligenceOperationDetails = new DocumentIntelligenceOperationDetails(status, createdOn, lastUpdatedOn, resourceLocation);
            deserializedDocumentIntelligenceOperationDetails.operationId = operationId;
            deserializedDocumentIntelligenceOperationDetails.kind = kind;
            deserializedDocumentIntelligenceOperationDetails.percentCompleted = percentCompleted;
            deserializedDocumentIntelligenceOperationDetails.apiVersion = apiVersion;
            deserializedDocumentIntelligenceOperationDetails.tags = tags;
            deserializedDocumentIntelligenceOperationDetails.error = error;
            return deserializedDocumentIntelligenceOperationDetails;
        });
    }
}

