/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.ClassifierDocumentTypeDetails;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

public final class BuildDocumentClassifierOptions
implements JsonSerializable<BuildDocumentClassifierOptions> {
    private final String classifierId;
    private String description;
    private String baseClassifierId;
    private final Map<String, ClassifierDocumentTypeDetails> documentTypes;
    private Boolean allowOverwrite;

    public BuildDocumentClassifierOptions(String classifierId, Map<String, ClassifierDocumentTypeDetails> documentTypes) {
        this.classifierId = classifierId;
        this.documentTypes = documentTypes;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public String getDescription() {
        return this.description;
    }

    public BuildDocumentClassifierOptions setDescription(String description) {
        this.description = description;
        return this;
    }

    public String getBaseClassifierId() {
        return this.baseClassifierId;
    }

    public BuildDocumentClassifierOptions setBaseClassifierId(String baseClassifierId) {
        this.baseClassifierId = baseClassifierId;
        return this;
    }

    public Map<String, ClassifierDocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    public Boolean isAllowOverwrite() {
        return this.allowOverwrite;
    }

    public BuildDocumentClassifierOptions setAllowOverwrite(Boolean allowOverwrite) {
        this.allowOverwrite = allowOverwrite;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeMapField("docTypes", this.documentTypes, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("baseClassifierId", this.baseClassifierId);
        jsonWriter.writeBooleanField("allowOverwrite", this.allowOverwrite);
        return jsonWriter.writeEndObject();
    }

    public static BuildDocumentClassifierOptions fromJson(JsonReader jsonReader) throws IOException {
        return (BuildDocumentClassifierOptions)jsonReader.readObject(reader -> {
            String classifierId = null;
            Map documentTypes = null;
            String description = null;
            String baseClassifierId = null;
            Boolean allowOverwrite = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    documentTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                if ("baseClassifierId".equals(fieldName)) {
                    baseClassifierId = reader.getString();
                    continue;
                }
                if ("allowOverwrite".equals(fieldName)) {
                    allowOverwrite = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            BuildDocumentClassifierOptions deserializedBuildDocumentClassifierOptions = new BuildDocumentClassifierOptions(classifierId, documentTypes);
            deserializedBuildDocumentClassifierOptions.description = description;
            deserializedBuildDocumentClassifierOptions.baseClassifierId = baseClassifierId;
            deserializedBuildDocumentClassifierOptions.allowOverwrite = allowOverwrite;
            return deserializedBuildDocumentClassifierOptions;
        });
    }
}

