/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AzureBlobFileListContentSource
implements JsonSerializable<AzureBlobFileListContentSource> {
    private final String containerUrl;
    private final String fileList;

    public AzureBlobFileListContentSource(String containerUrl, String fileList) {
        this.containerUrl = containerUrl;
        this.fileList = fileList;
    }

    public String getContainerUrl() {
        return this.containerUrl;
    }

    public String getFileList() {
        return this.fileList;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("containerUrl", this.containerUrl);
        jsonWriter.writeStringField("fileList", this.fileList);
        return jsonWriter.writeEndObject();
    }

    public static AzureBlobFileListContentSource fromJson(JsonReader jsonReader) throws IOException {
        return (AzureBlobFileListContentSource)jsonReader.readObject(reader -> {
            String containerUrl = null;
            String fileList = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerUrl".equals(fieldName)) {
                    containerUrl = reader.getString();
                    continue;
                }
                if ("fileList".equals(fieldName)) {
                    fileList = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new AzureBlobFileListContentSource(containerUrl, fileList);
        });
    }
}

