/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.implementation.AnalyzeOperationDetailsHelper;
import com.azure.ai.documentintelligence.models.AnalyzeResult;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceError;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnalyzeOperationDetails
implements JsonSerializable<AnalyzeOperationDetails> {
    private final DocumentIntelligenceOperationStatus status;
    private final OffsetDateTime createdOn;
    private final OffsetDateTime lastUpdatedOn;
    private DocumentIntelligenceError error;
    private AnalyzeResult analyzeResult;
    private String operationId;

    private AnalyzeOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn, OffsetDateTime lastUpdatedOn) {
        this.status = status;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public DocumentIntelligenceError getError() {
        return this.error;
    }

    public AnalyzeResult getAnalyzeResult() {
        return this.analyzeResult;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedOn));
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("analyzeResult", (JsonSerializable)this.analyzeResult);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeOperationDetails)jsonReader.readObject(reader -> {
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            DocumentIntelligenceError error = null;
            AnalyzeResult analyzeResult = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                    continue;
                }
                if ("analyzeResult".equals(fieldName)) {
                    analyzeResult = AnalyzeResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeOperationDetails deserializedAnalyzeOperationDetails = new AnalyzeOperationDetails(status, createdOn, lastUpdatedOn);
            deserializedAnalyzeOperationDetails.error = error;
            deserializedAnalyzeOperationDetails.analyzeResult = analyzeResult;
            return deserializedAnalyzeOperationDetails;
        });
    }

    public String getResultId() {
        return this.operationId;
    }

    private void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    static {
        AnalyzeOperationDetailsHelper.setAccessor(new AnalyzeOperationDetailsHelper.AnalyzeOperationDetailsAccessor(){

            @Override
            public void setOperationId(AnalyzeOperationDetails analyzeOperation, String operationId) {
                analyzeOperation.setOperationId(operationId);
            }
        });
    }
}

