/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeOutputFormat;
import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentContentFormat;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public final class AnalyzeBatchDocumentsOptions
implements JsonSerializable<AnalyzeBatchDocumentsOptions> {
    private List<String> pages;
    private String locale;
    private List<DocumentAnalysisFeature> documentAnalysisFeatures;
    private StringIndexType stringIndexType;
    private List<String> queryFields;
    private DocumentContentFormat outputContentFormat;
    private List<AnalyzeOutputFormat> output;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private final String resultContainerUrl;
    private String resultPrefix;
    private Boolean overwriteExisting;

    public AnalyzeBatchDocumentsOptions(AzureBlobContentSource azureBlobSource, String resultContainerUrl) {
        Objects.requireNonNull(azureBlobSource, "'azureBlobSource' cannot be null");
        Objects.requireNonNull(resultContainerUrl, "'resultContainerUrl' cannot be null");
        this.azureBlobSource = azureBlobSource;
        this.resultContainerUrl = resultContainerUrl;
    }

    public AnalyzeBatchDocumentsOptions(AzureBlobFileListContentSource azureBlobFileListSource, String resultContainerUrl) {
        Objects.requireNonNull(azureBlobFileListSource, "'azureBlobFileListSource' cannot be null");
        Objects.requireNonNull(resultContainerUrl, "'resultContainerUrl' cannot be null");
        this.resultContainerUrl = resultContainerUrl;
        this.azureBlobFileListSource = azureBlobFileListSource;
    }

    AnalyzeBatchDocumentsOptions(String resultContainerUrl) {
        this.resultContainerUrl = resultContainerUrl;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public String getResultContainerUrl() {
        return this.resultContainerUrl;
    }

    public String getResultPrefix() {
        return this.resultPrefix;
    }

    public AnalyzeBatchDocumentsOptions setResultPrefix(String resultPrefix) {
        this.resultPrefix = resultPrefix;
        return this;
    }

    public Boolean isOverwriteExisting() {
        return this.overwriteExisting;
    }

    public AnalyzeBatchDocumentsOptions setOverwriteExisting(Boolean overwriteExisting) {
        this.overwriteExisting = overwriteExisting;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("resultContainerUrl", this.resultContainerUrl);
        jsonWriter.writeJsonField("azureBlobSource", (JsonSerializable)this.azureBlobSource);
        jsonWriter.writeJsonField("azureBlobFileListSource", (JsonSerializable)this.azureBlobFileListSource);
        jsonWriter.writeStringField("resultPrefix", this.resultPrefix);
        jsonWriter.writeBooleanField("overwriteExisting", this.overwriteExisting);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchDocumentsOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchDocumentsOptions)jsonReader.readObject(reader -> {
            String resultContainerUrl = null;
            AzureBlobContentSource azureBlobSource = null;
            AzureBlobFileListContentSource azureBlobFileListSource = null;
            String resultPrefix = null;
            Boolean overwriteExisting = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("resultContainerUrl".equals(fieldName)) {
                    resultContainerUrl = reader.getString();
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("resultPrefix".equals(fieldName)) {
                    resultPrefix = reader.getString();
                    continue;
                }
                if ("overwriteExisting".equals(fieldName)) {
                    overwriteExisting = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchDocumentsOptions deserializedAnalyzeBatchDocumentsOptions = new AnalyzeBatchDocumentsOptions(resultContainerUrl);
            deserializedAnalyzeBatchDocumentsOptions.azureBlobSource = azureBlobSource;
            deserializedAnalyzeBatchDocumentsOptions.azureBlobFileListSource = azureBlobFileListSource;
            deserializedAnalyzeBatchDocumentsOptions.resultPrefix = resultPrefix;
            deserializedAnalyzeBatchDocumentsOptions.overwriteExisting = overwriteExisting;
            return deserializedAnalyzeBatchDocumentsOptions;
        });
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    public AnalyzeBatchDocumentsOptions setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    public DocumentContentFormat getOutputContentFormat() {
        return this.outputContentFormat;
    }

    public AnalyzeBatchDocumentsOptions setOutputContentFormat(DocumentContentFormat outputContentFormat) {
        this.outputContentFormat = outputContentFormat;
        return this;
    }

    public List<AnalyzeOutputFormat> getOutput() {
        return this.output;
    }

    public AnalyzeBatchDocumentsOptions setOutput(List<AnalyzeOutputFormat> output) {
        this.output = output;
        return this;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public AnalyzeBatchDocumentsOptions setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public AnalyzeBatchDocumentsOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public AnalyzeBatchDocumentsOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public List<DocumentAnalysisFeature> getDocumentAnalysisFeatures() {
        return this.documentAnalysisFeatures;
    }

    public AnalyzeBatchDocumentsOptions setDocumentAnalysisFeatures(List<DocumentAnalysisFeature> documentAnalysisFeatures) {
        this.documentAnalysisFeatures = documentAnalysisFeatures;
        return this;
    }

    public AnalyzeBatchDocumentsOptions setDocumentAnalysisFeatures(DocumentAnalysisFeature ... documentAnalysisFeatures) {
        if (documentAnalysisFeatures != null) {
            this.documentAnalysisFeatures = Arrays.asList(documentAnalysisFeatures);
        }
        return this;
    }

    AnalyzeBatchDocumentsOptions setAzureBlobSource(AzureBlobContentSource azureBlobSource) {
        this.azureBlobSource = azureBlobSource;
        return this;
    }

    AnalyzeBatchDocumentsOptions setAzureBlobFileListSource(AzureBlobFileListContentSource azureBlobFileListSource) {
        this.azureBlobFileListSource = azureBlobFileListSource;
        return this;
    }
}

