/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentKeyValueElement;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class DocumentKeyValuePair
implements JsonSerializable<DocumentKeyValuePair> {
    private final DocumentKeyValueElement key;
    private DocumentKeyValueElement value;
    private final double confidence;

    private DocumentKeyValuePair(DocumentKeyValueElement key, double confidence) {
        this.key = key;
        this.confidence = confidence;
    }

    public DocumentKeyValueElement getKey() {
        return this.key;
    }

    public DocumentKeyValueElement getValue() {
        return this.value;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeDoubleField("confidence", this.confidence);
        jsonWriter.writeJsonField("value", (JsonSerializable)this.value);
        return jsonWriter.writeEndObject();
    }

    public static DocumentKeyValuePair fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentKeyValuePair)jsonReader.readObject(reader -> {
            DocumentKeyValueElement key = null;
            double confidence = 0.0;
            DocumentKeyValueElement value = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    key = DocumentKeyValueElement.fromJson(reader);
                    continue;
                }
                if ("confidence".equals(fieldName)) {
                    confidence = reader.getDouble();
                    continue;
                }
                if ("value".equals(fieldName)) {
                    value = DocumentKeyValueElement.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            DocumentKeyValuePair deserializedDocumentKeyValuePair = new DocumentKeyValuePair(key, confidence);
            deserializedDocumentKeyValuePair.value = value;
            return deserializedDocumentKeyValuePair;
        });
    }
}

