/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AzureBlobContentSource;
import com.azure.ai.documentintelligence.models.AzureBlobFileListContentSource;
import com.azure.ai.documentintelligence.models.DocumentBuildMode;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceWarning;
import com.azure.ai.documentintelligence.models.DocumentTypeDetails;
import com.azure.ai.documentintelligence.models.SplitMode;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class DocumentModelDetails
implements JsonSerializable<DocumentModelDetails> {
    private String modelId;
    private String description;
    private OffsetDateTime createdOn;
    private OffsetDateTime expiresOn;
    private OffsetDateTime modifiedOn;
    private String apiVersion;
    private Map<String, String> tags;
    private DocumentBuildMode buildMode;
    private AzureBlobContentSource azureBlobSource;
    private AzureBlobFileListContentSource azureBlobFileListSource;
    private String classifierId;
    private SplitMode split;
    private Map<String, DocumentTypeDetails> documentTypes;
    private List<DocumentIntelligenceWarning> warnings;
    private Double trainingHours;

    private DocumentModelDetails() {
    }

    public String getModelId() {
        return this.modelId;
    }

    public String getDescription() {
        return this.description;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public DocumentBuildMode getBuildMode() {
        return this.buildMode;
    }

    public AzureBlobContentSource getAzureBlobSource() {
        return this.azureBlobSource;
    }

    public AzureBlobFileListContentSource getAzureBlobFileListSource() {
        return this.azureBlobFileListSource;
    }

    public String getClassifierId() {
        return this.classifierId;
    }

    public SplitMode getSplit() {
        return this.split;
    }

    public Map<String, DocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    public List<DocumentIntelligenceWarning> getWarnings() {
        return this.warnings;
    }

    public Double getTrainingHours() {
        return this.trainingHours;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("classifierId", this.classifierId);
        jsonWriter.writeStringField("split", this.split == null ? null : this.split.toString());
        return jsonWriter.writeEndObject();
    }

    public static DocumentModelDetails fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentModelDetails)jsonReader.readObject(reader -> {
            DocumentModelDetails deserializedDocumentModelDetails = new DocumentModelDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("modelId".equals(fieldName)) {
                    deserializedDocumentModelDetails.modelId = reader.getString();
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedDocumentModelDetails.description = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("modifiedDateTime".equals(fieldName)) {
                    deserializedDocumentModelDetails.modifiedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("apiVersion".equals(fieldName)) {
                    deserializedDocumentModelDetails.apiVersion = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedDocumentModelDetails.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("buildMode".equals(fieldName)) {
                    deserializedDocumentModelDetails.buildMode = DocumentBuildMode.fromString(reader.getString());
                    continue;
                }
                if ("azureBlobSource".equals(fieldName)) {
                    deserializedDocumentModelDetails.azureBlobSource = AzureBlobContentSource.fromJson(reader);
                    continue;
                }
                if ("azureBlobFileListSource".equals(fieldName)) {
                    deserializedDocumentModelDetails.azureBlobFileListSource = AzureBlobFileListContentSource.fromJson(reader);
                    continue;
                }
                if ("classifierId".equals(fieldName)) {
                    deserializedDocumentModelDetails.classifierId = reader.getString();
                    continue;
                }
                if ("split".equals(fieldName)) {
                    deserializedDocumentModelDetails.split = SplitMode.fromString(reader.getString());
                    continue;
                }
                if ("docTypes".equals(fieldName)) {
                    Map documentTypes;
                    deserializedDocumentModelDetails.documentTypes = documentTypes = reader.readMap(reader1 -> DocumentTypeDetails.fromJson(reader1));
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings;
                    deserializedDocumentModelDetails.warnings = warnings = reader.readArray(reader1 -> DocumentIntelligenceWarning.fromJson(reader1));
                    continue;
                }
                if ("trainingHours".equals(fieldName)) {
                    deserializedDocumentModelDetails.trainingHours = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentModelDetails;
        });
    }
}

