/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class ClassifierCopyAuthorization
implements JsonSerializable<ClassifierCopyAuthorization> {
    private final String targetResourceId;
    private final String targetResourceRegion;
    private final String targetClassifierId;
    private final String targetClassifierLocation;
    private final String accessToken;
    private final OffsetDateTime expiresOn;

    public ClassifierCopyAuthorization(String targetResourceId, String targetResourceRegion, String targetClassifierId, String targetClassifierLocation, String accessToken, OffsetDateTime expiresOn) {
        this.targetResourceId = targetResourceId;
        this.targetResourceRegion = targetResourceRegion;
        this.targetClassifierId = targetClassifierId;
        this.targetClassifierLocation = targetClassifierLocation;
        this.accessToken = accessToken;
        this.expiresOn = expiresOn;
    }

    public String getTargetResourceId() {
        return this.targetResourceId;
    }

    public String getTargetResourceRegion() {
        return this.targetResourceRegion;
    }

    public String getTargetClassifierId() {
        return this.targetClassifierId;
    }

    public String getTargetClassifierLocation() {
        return this.targetClassifierLocation;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetResourceId", this.targetResourceId);
        jsonWriter.writeStringField("targetResourceRegion", this.targetResourceRegion);
        jsonWriter.writeStringField("targetClassifierId", this.targetClassifierId);
        jsonWriter.writeStringField("targetClassifierLocation", this.targetClassifierLocation);
        jsonWriter.writeStringField("accessToken", this.accessToken);
        jsonWriter.writeStringField("expirationDateTime", this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        return jsonWriter.writeEndObject();
    }

    public static ClassifierCopyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (ClassifierCopyAuthorization)jsonReader.readObject(reader -> {
            String targetResourceId = null;
            String targetResourceRegion = null;
            String targetClassifierId = null;
            String targetClassifierLocation = null;
            String accessToken = null;
            OffsetDateTime expiresOn = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("targetResourceId".equals(fieldName)) {
                    targetResourceId = reader.getString();
                    continue;
                }
                if ("targetResourceRegion".equals(fieldName)) {
                    targetResourceRegion = reader.getString();
                    continue;
                }
                if ("targetClassifierId".equals(fieldName)) {
                    targetClassifierId = reader.getString();
                    continue;
                }
                if ("targetClassifierLocation".equals(fieldName)) {
                    targetClassifierLocation = reader.getString();
                    continue;
                }
                if ("accessToken".equals(fieldName)) {
                    accessToken = reader.getString();
                    continue;
                }
                if ("expirationDateTime".equals(fieldName)) {
                    expiresOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return new ClassifierCopyAuthorization(targetResourceId, targetResourceRegion, targetClassifierId, targetClassifierLocation, accessToken, expiresOn);
        });
    }
}

