/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeOutputFormat;
import com.azure.ai.documentintelligence.models.DocumentAnalysisFeature;
import com.azure.ai.documentintelligence.models.DocumentContentFormat;
import com.azure.ai.documentintelligence.models.StringIndexType;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class AnalyzeDocumentOptions
implements JsonSerializable<AnalyzeDocumentOptions> {
    private List<String> pages;
    private String locale;
    private List<DocumentAnalysisFeature> documentAnalysisFeatures;
    private StringIndexType stringIndexType;
    private List<String> queryFields;
    private DocumentContentFormat outputContentFormat;
    private List<AnalyzeOutputFormat> output;
    private String urlSource;
    private byte[] bytesSource;

    AnalyzeDocumentOptions() {
    }

    public AnalyzeDocumentOptions(String urlSource) {
        this.urlSource = urlSource;
    }

    public AnalyzeDocumentOptions(byte[] bytesSource) {
        this.bytesSource = bytesSource;
    }

    public AnalyzeDocumentOptions(BinaryData binaryData) {
        if (binaryData != null) {
            this.bytesSource = binaryData.toBytes();
        }
    }

    public String getUrlSource() {
        return this.urlSource;
    }

    AnalyzeDocumentOptions setUrlSource(String urlSource) {
        this.urlSource = urlSource;
        return this;
    }

    public byte[] getBytesSource() {
        return CoreUtils.clone((byte[])this.bytesSource);
    }

    AnalyzeDocumentOptions setBytesSource(byte[] bytesSource) {
        this.bytesSource = CoreUtils.clone((byte[])bytesSource);
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("urlSource", this.urlSource);
        jsonWriter.writeBinaryField("base64Source", this.bytesSource);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeDocumentOptions fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeDocumentOptions)jsonReader.readObject(reader -> {
            AnalyzeDocumentOptions deserializedAnalyzeDocumentOptions = new AnalyzeDocumentOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("urlSource".equals(fieldName)) {
                    deserializedAnalyzeDocumentOptions.urlSource = reader.getString();
                    continue;
                }
                if ("base64Source".equals(fieldName)) {
                    deserializedAnalyzeDocumentOptions.bytesSource = reader.getBinary();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeDocumentOptions;
        });
    }

    public List<String> getQueryFields() {
        return this.queryFields;
    }

    public AnalyzeDocumentOptions setQueryFields(List<String> queryFields) {
        this.queryFields = queryFields;
        return this;
    }

    public DocumentContentFormat getOutputContentFormat() {
        return this.outputContentFormat;
    }

    public AnalyzeDocumentOptions setOutputContentFormat(DocumentContentFormat outputContentFormat) {
        this.outputContentFormat = outputContentFormat;
        return this;
    }

    public List<AnalyzeOutputFormat> getOutput() {
        return this.output;
    }

    public AnalyzeDocumentOptions setOutput(List<AnalyzeOutputFormat> output) {
        this.output = output;
        return this;
    }

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public AnalyzeDocumentOptions setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    public List<String> getPages() {
        return this.pages;
    }

    public AnalyzeDocumentOptions setPages(List<String> pages) {
        this.pages = pages;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public AnalyzeDocumentOptions setLocale(String locale) {
        this.locale = locale;
        return this;
    }

    public List<DocumentAnalysisFeature> getDocumentAnalysisFeatures() {
        return this.documentAnalysisFeatures;
    }

    public AnalyzeDocumentOptions setDocumentAnalysisFeatures(List<DocumentAnalysisFeature> documentAnalysisFeatures) {
        this.documentAnalysisFeatures = documentAnalysisFeatures;
        return this;
    }

    public AnalyzeDocumentOptions setDocumentAnalysisFeatures(DocumentAnalysisFeature ... documentAnalysisFeatures) {
        if (documentAnalysisFeatures != null) {
            this.documentAnalysisFeatures = Arrays.asList(documentAnalysisFeatures);
        }
        return this;
    }
}

