/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.DocumentIntelligenceError;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class AnalyzeBatchResultDetails
implements JsonSerializable<AnalyzeBatchResultDetails> {
    private final DocumentIntelligenceOperationStatus status;
    private final String sourceUrl;
    private String resultUrl;
    private DocumentIntelligenceError error;

    private AnalyzeBatchResultDetails(DocumentIntelligenceOperationStatus status, String sourceUrl) {
        this.status = status;
        this.sourceUrl = sourceUrl;
    }

    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    public String getSourceUrl() {
        return this.sourceUrl;
    }

    public String getResultUrl() {
        return this.resultUrl;
    }

    public DocumentIntelligenceError getError() {
        return this.error;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("sourceUrl", this.sourceUrl);
        jsonWriter.writeStringField("resultUrl", this.resultUrl);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchResultDetails fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchResultDetails)jsonReader.readObject(reader -> {
            DocumentIntelligenceOperationStatus status = null;
            String sourceUrl = null;
            String resultUrl = null;
            DocumentIntelligenceError error = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("sourceUrl".equals(fieldName)) {
                    sourceUrl = reader.getString();
                    continue;
                }
                if ("resultUrl".equals(fieldName)) {
                    resultUrl = reader.getString();
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchResultDetails deserializedAnalyzeBatchResultDetails = new AnalyzeBatchResultDetails(status, sourceUrl);
            deserializedAnalyzeBatchResultDetails.resultUrl = resultUrl;
            deserializedAnalyzeBatchResultDetails.error = error;
            return deserializedAnalyzeBatchResultDetails;
        });
    }
}

