/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.documentintelligence.models;

import com.azure.ai.documentintelligence.models.AnalyzeBatchResult;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceError;
import com.azure.ai.documentintelligence.models.DocumentIntelligenceOperationStatus;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class AnalyzeBatchOperationDetails
implements JsonSerializable<AnalyzeBatchOperationDetails> {
    private String resultId;
    private final DocumentIntelligenceOperationStatus status;
    private final OffsetDateTime createdOn;
    private final OffsetDateTime lastUpdatedOn;
    private Integer percentCompleted;
    private DocumentIntelligenceError error;
    private AnalyzeBatchResult result;

    private AnalyzeBatchOperationDetails(DocumentIntelligenceOperationStatus status, OffsetDateTime createdOn, OffsetDateTime lastUpdatedOn) {
        this.status = status;
        this.createdOn = createdOn;
        this.lastUpdatedOn = lastUpdatedOn;
    }

    public String getResultId() {
        return this.resultId;
    }

    public DocumentIntelligenceOperationStatus getStatus() {
        return this.status;
    }

    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    public OffsetDateTime getLastUpdatedOn() {
        return this.lastUpdatedOn;
    }

    public Integer getPercentCompleted() {
        return this.percentCompleted;
    }

    public DocumentIntelligenceError getError() {
        return this.error;
    }

    public AnalyzeBatchResult getResult() {
        return this.result;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("status", this.status == null ? null : this.status.toString());
        jsonWriter.writeStringField("createdDateTime", this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("lastUpdatedDateTime", this.lastUpdatedOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastUpdatedOn));
        jsonWriter.writeStringField("resultId", this.resultId);
        jsonWriter.writeNumberField("percentCompleted", (Number)this.percentCompleted);
        jsonWriter.writeJsonField("error", (JsonSerializable)this.error);
        jsonWriter.writeJsonField("result", (JsonSerializable)this.result);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeBatchOperationDetails fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeBatchOperationDetails)jsonReader.readObject(reader -> {
            DocumentIntelligenceOperationStatus status = null;
            OffsetDateTime createdOn = null;
            OffsetDateTime lastUpdatedOn = null;
            String resultId = null;
            Integer percentCompleted = null;
            DocumentIntelligenceError error = null;
            AnalyzeBatchResult result = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("status".equals(fieldName)) {
                    status = DocumentIntelligenceOperationStatus.fromString(reader.getString());
                    continue;
                }
                if ("createdDateTime".equals(fieldName)) {
                    createdOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("lastUpdatedDateTime".equals(fieldName)) {
                    lastUpdatedOn = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("resultId".equals(fieldName)) {
                    resultId = reader.getString();
                    continue;
                }
                if ("percentCompleted".equals(fieldName)) {
                    percentCompleted = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("error".equals(fieldName)) {
                    error = DocumentIntelligenceError.fromJson(reader);
                    continue;
                }
                if ("result".equals(fieldName)) {
                    result = AnalyzeBatchResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            AnalyzeBatchOperationDetails deserializedAnalyzeBatchOperationDetails = new AnalyzeBatchOperationDetails(status, createdOn, lastUpdatedOn);
            deserializedAnalyzeBatchOperationDetails.resultId = resultId;
            deserializedAnalyzeBatchOperationDetails.percentCompleted = percentCompleted;
            deserializedAnalyzeBatchOperationDetails.error = error;
            deserializedAnalyzeBatchOperationDetails.result = result;
            return deserializedAnalyzeBatchOperationDetails;
        });
    }
}

