// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object containing more specific information about the error.
 */
@Immutable
public final class DocumentIntelligenceInnerError implements JsonSerializable<DocumentIntelligenceInnerError> {

    /*
     * One of a server-defined set of error codes.
     */
    @Generated
    private String code;

    /*
     * A human-readable representation of the error.
     */
    @Generated
    private String message;

    /**
     * Creates an instance of DocumentIntelligenceInnerError class.
     */
    @Generated
    private DocumentIntelligenceInnerError() {
    }

    /**
     * Get the code property: One of a server-defined set of error codes.
     *
     * @return the code value.
     */
    @Generated
    public String getCode() {
        return this.code;
    }

    /**
     * Get the message property: A human-readable representation of the error.
     *
     * @return the message value.
     */
    @Generated
    public String getMessage() {
        return this.message;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeJsonField("innererror", this.innerError);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentIntelligenceInnerError from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentIntelligenceInnerError if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DocumentIntelligenceInnerError.
     */
    @Generated
    public static DocumentIntelligenceInnerError fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DocumentIntelligenceInnerError deserializedDocumentIntelligenceInnerError
                = new DocumentIntelligenceInnerError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedDocumentIntelligenceInnerError.code = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedDocumentIntelligenceInnerError.message = reader.getString();
                } else if ("innererror".equals(fieldName)) {
                    deserializedDocumentIntelligenceInnerError.innerError
                        = DocumentIntelligenceInnerError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }
            return deserializedDocumentIntelligenceInnerError;
        });
    }

    /*
     * Inner error.
     */
    @Generated
    private DocumentIntelligenceInnerError innerError;

    /**
     * Get the innerError property: Inner error.
     *
     * @return the innerError value.
     */
    @Generated
    public DocumentIntelligenceInnerError getInnerError() {
        return this.innerError;
    }
}
