// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) TypeSpec Code Generator.
package com.azure.ai.documentintelligence.models;

import com.azure.core.annotation.Generated;
import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Map;

/**
 * Document classifier info.
 */
@Immutable
public final class DocumentClassifierDetails implements JsonSerializable<DocumentClassifierDetails> {

    /*
     * Unique document classifier name.
     */
    @Generated
    private String classifierId;

    /*
     * Document classifier description.
     */
    @Generated
    private String description;

    /*
     * Date and time (UTC) when the document classifier was created.
     */
    @Generated
    private final OffsetDateTime createdOn;

    /*
     * Date and time (UTC) when the document classifier will expire.
     */
    @Generated
    private OffsetDateTime expiresOn;

    /*
     * Date and time (UTC) when the document model was last modified.
     */
    @Generated
    private OffsetDateTime modifiedOn;

    /*
     * API version used to create this document classifier.
     */
    @Generated
    private final String apiVersion;

    /*
     * Base classifierId on top of which the classifier was trained.
     */
    @Generated
    private String baseClassifierId;

    /*
     * List of document types to classify against.
     */
    @Generated
    private final Map<String, ClassifierDocumentTypeDetails> documentTypes;

    /*
     * List of warnings encountered while building the classifier.
     */
    @Generated
    private List<DocumentIntelligenceWarning> warnings;

    /**
     * Creates an instance of DocumentClassifierDetails class.
     *
     * @param createdOn the createdOn value to set.
     * @param apiVersion the apiVersion value to set.
     * @param documentTypes the documentTypes value to set.
     */
    @Generated
    private DocumentClassifierDetails(OffsetDateTime createdOn, String apiVersion,
        Map<String, ClassifierDocumentTypeDetails> documentTypes) {
        this.createdOn = createdOn;
        this.apiVersion = apiVersion;
        this.documentTypes = documentTypes;
    }

    /**
     * Get the classifierId property: Unique document classifier name.
     *
     * @return the classifierId value.
     */
    @Generated
    public String getClassifierId() {
        return this.classifierId;
    }

    /**
     * Get the description property: Document classifier description.
     *
     * @return the description value.
     */
    @Generated
    public String getDescription() {
        return this.description;
    }

    /**
     * Get the createdOn property: Date and time (UTC) when the document classifier was created.
     *
     * @return the createdOn value.
     */
    @Generated
    public OffsetDateTime getCreatedOn() {
        return this.createdOn;
    }

    /**
     * Get the expiresOn property: Date and time (UTC) when the document classifier will expire.
     *
     * @return the expiresOn value.
     */
    @Generated
    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    /**
     * Get the modifiedOn property: Date and time (UTC) when the document model was last modified.
     *
     * @return the modifiedOn value.
     */
    @Generated
    public OffsetDateTime getModifiedOn() {
        return this.modifiedOn;
    }

    /**
     * Get the apiVersion property: API version used to create this document classifier.
     *
     * @return the apiVersion value.
     */
    @Generated
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * Get the baseClassifierId property: Base classifierId on top of which the classifier was trained.
     *
     * @return the baseClassifierId value.
     */
    @Generated
    public String getBaseClassifierId() {
        return this.baseClassifierId;
    }

    /**
     * Get the documentTypes property: List of document types to classify against.
     *
     * @return the documentTypes value.
     */
    @Generated
    public Map<String, ClassifierDocumentTypeDetails> getDocumentTypes() {
        return this.documentTypes;
    }

    /**
     * Get the warnings property: List of warnings encountered while building the classifier.
     *
     * @return the warnings value.
     */
    @Generated
    public List<DocumentIntelligenceWarning> getWarnings() {
        return this.warnings;
    }

    /**
     * {@inheritDoc}
     */
    @Generated
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdDateTime",
            this.createdOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdOn));
        jsonWriter.writeStringField("apiVersion", this.apiVersion);
        jsonWriter.writeMapField("docTypes", this.documentTypes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("expirationDateTime",
            this.expiresOn == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.expiresOn));
        jsonWriter.writeStringField("baseClassifierId", this.baseClassifierId);
        jsonWriter.writeArrayField("warnings", this.warnings, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DocumentClassifierDetails from the JsonReader.
     *
     * @param jsonReader The JsonReader being read.
     * @return An instance of DocumentClassifierDetails if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DocumentClassifierDetails.
     */
    @Generated
    public static DocumentClassifierDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            String classifierId = null;
            OffsetDateTime createdOn = null;
            String apiVersion = null;
            Map<String, ClassifierDocumentTypeDetails> documentTypes = null;
            String description = null;
            OffsetDateTime expiresOn = null;
            OffsetDateTime modifiedOn = null;
            String baseClassifierId = null;
            List<DocumentIntelligenceWarning> warnings = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("classifierId".equals(fieldName)) {
                    classifierId = reader.getString();
                } else if ("createdDateTime".equals(fieldName)) {
                    createdOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("apiVersion".equals(fieldName)) {
                    apiVersion = reader.getString();
                } else if ("docTypes".equals(fieldName)) {
                    documentTypes = reader.readMap(reader1 -> ClassifierDocumentTypeDetails.fromJson(reader1));
                } else if ("description".equals(fieldName)) {
                    description = reader.getString();
                } else if ("expirationDateTime".equals(fieldName)) {
                    expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("modifiedDateTime".equals(fieldName)) {
                    modifiedOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("baseClassifierId".equals(fieldName)) {
                    baseClassifierId = reader.getString();
                } else if ("warnings".equals(fieldName)) {
                    warnings = reader.readArray(reader1 -> DocumentIntelligenceWarning.fromJson(reader1));
                } else {
                    reader.skipChildren();
                }
            }
            DocumentClassifierDetails deserializedDocumentClassifierDetails
                = new DocumentClassifierDetails(createdOn, apiVersion, documentTypes);
            deserializedDocumentClassifierDetails.classifierId = classifierId;
            deserializedDocumentClassifierDetails.description = description;
            deserializedDocumentClassifierDetails.expiresOn = expiresOn;
            deserializedDocumentClassifierDetails.modifiedOn = modifiedOn;
            deserializedDocumentClassifierDetails.baseClassifierId = baseClassifierId;
            deserializedDocumentClassifierDetails.warnings = warnings;
            return deserializedDocumentClassifierDetails;
        });
    }
}
